/*
 * Decompiled with CFR 0.152.
 */
package discord4j.common.store.impl;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.RemovalListener;
import discord4j.common.store.impl.NoOpMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.UnaryOperator;
import reactor.util.annotation.Nullable;

public interface StorageBackend {
    public static StorageBackend noOp() {
        return new StorageBackend(){

            @Override
            public <K, V> ConcurrentMap<K, V> newMap(@Nullable RemovalListener<K, V> removalListener) {
                return new NoOpMap();
            }
        };
    }

    public static StorageBackend concurrentHashMap() {
        return new StorageBackend(){

            @Override
            public <K, V> ConcurrentMap<K, V> newMap(@Nullable RemovalListener<K, V> removalListener) {
                return new ConcurrentHashMap();
            }
        };
    }

    public static StorageBackend caffeine(final UnaryOperator<Caffeine<Object, Object>> caffeineBuilder) {
        return new StorageBackend(){

            @Override
            public <K, V> ConcurrentMap<K, V> newMap(@Nullable RemovalListener<K, V> removalListener) {
                Caffeine configured = (Caffeine)caffeineBuilder.apply(Caffeine.newBuilder());
                if (removalListener != null) {
                    return configured.removalListener(removalListener).build().asMap();
                }
                return configured.build().asMap();
            }
        };
    }

    default public <K, V> ConcurrentMap<K, V> newMap() {
        return this.newMap(null);
    }

    public <K, V> ConcurrentMap<K, V> newMap(@Nullable RemovalListener<K, V> var1);
}

