/*
 * Decompiled with CFR 0.152.
 */
package discord4j.gateway.json;

import com.fasterxml.jackson.annotation.JsonIgnore;
import discord4j.discordjson.json.gateway.PayloadData;
import discord4j.discordjson.json.gateway.RequestGuildMembers;
import discord4j.discordjson.json.gateway.StatusUpdate;
import discord4j.discordjson.json.gateway.VoiceStateUpdate;
import discord4j.gateway.json.GatewayPayload;

public class ShardGatewayPayload<T extends PayloadData>
extends GatewayPayload<T> {
    @JsonIgnore
    private final int shardIndex;

    public ShardGatewayPayload(GatewayPayload<T> payload, int shardIndex) {
        super(payload.getOp(), payload.getData(), payload.getSequence(), payload.getType());
        this.shardIndex = shardIndex;
    }

    public static ShardGatewayPayload<StatusUpdate> statusUpdate(StatusUpdate data, int shardId) {
        return new ShardGatewayPayload<StatusUpdate>(GatewayPayload.statusUpdate(data), shardId);
    }

    public static ShardGatewayPayload<VoiceStateUpdate> voiceStateUpdate(VoiceStateUpdate data, int shardId) {
        return new ShardGatewayPayload<VoiceStateUpdate>(GatewayPayload.voiceStateUpdate(data), shardId);
    }

    public static ShardGatewayPayload<RequestGuildMembers> requestGuildMembers(RequestGuildMembers data, int shardId) {
        return new ShardGatewayPayload<RequestGuildMembers>(GatewayPayload.requestGuildMembers(data), shardId);
    }

    @JsonIgnore
    public int getShardIndex() {
        return this.shardIndex;
    }
}

