/*
 * This file is part of Discord4J.
 *
 * Discord4J is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Discord4J is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with Discord4J. If not, see <http://www.gnu.org/licenses/>.
 */

package discord4j.voice.retry;

import reactor.util.context.ContextView;

public class VoiceGatewayException extends RuntimeException {

    private final ContextView context;

    public VoiceGatewayException(ContextView context) {
        this.context = context;
    }

    public VoiceGatewayException(ContextView context, String message) {
        super(message);
        this.context = context;
    }

    public VoiceGatewayException(ContextView context, String message, Throwable cause) {
        super(message, cause);
        this.context = context;
    }

    public ContextView getContext() {
        return context;
    }

    @Override
    public String toString() {
        String prefix = "Voice gateway exception";
        String message = getMessage();
        return (message != null) ? (prefix + ": " + message) : prefix;
    }


}
