/*
 * Decompiled with CFR 0.152.
 */
package com.dkanejs.maven.plugins.docker.compose;

import com.dkanejs.maven.plugins.docker.compose.BuildArguments;
import com.dkanejs.maven.plugins.docker.compose.DockerComposeException;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;

abstract class AbstractDockerComposeMojo
extends AbstractMojo {
    @Parameter(property="dockerCompose.projectName")
    private String projectName;
    @Parameter(property="dockerCompose.host")
    private String host;
    @Parameter(defaultValue="false", property="dockerCompose.removeVolumes")
    boolean removeVolumes;
    @Parameter(defaultValue="false", property="dockerCompose.removeImages")
    boolean removeImages;
    @Parameter(defaultValue="all", property="dockerCompose.removeImages.type")
    String removeImagesType;
    @Parameter(defaultValue="false", property="dockerCompose.detached")
    protected boolean detachedMode;
    @Parameter(defaultValue="false", property="dockerCompose.build")
    protected boolean build;
    @Parameter(property="dockerCompose.buildArgs")
    protected BuildArguments buildArgs;
    @Parameter(defaultValue="${project.basedir}/src/main/resources/docker-compose.yml", property="dockerCompose.file")
    private String composeFile;
    @Parameter(property="dockerCompose.composeFiles")
    private List<String> composeFiles;
    @Parameter(property="dockerCompose.services")
    protected List<String> services;
    @Parameter(property="dockerCompose.apiVersion")
    private String apiVersion;
    @Parameter(defaultValue="false", property="dockerCompose.verbose")
    private boolean verbose;
    @Parameter(defaultValue="false", property="dockerCompose.skip")
    boolean skip;
    @Parameter(defaultValue="false", property="dockerCompose.removeOrphans")
    boolean removeOrphans;
    @Parameter(property="dockerCompose.envFile")
    private String envFile;
    @Parameter(property="dockerCompose.envVars")
    private Map<String, String> envVars;
    @Parameter(property="dockerCompose.awaitCmd")
    String awaitCmd;
    @Parameter(property="dockerCompose.awaitCmdArgs")
    String awaitCmdArgs;
    @Parameter(property="dockerCompose.awaitTimeout", defaultValue="30")
    int awaitTimeout;
    @Parameter(defaultValue="false", property="dockerCompose.ignorePullFailures")
    boolean ignorePullFailures;

    AbstractDockerComposeMojo() {
    }

    void execute(List<String> args) throws MojoExecutionException {
        ProcessBuilder pb = this.buildProcess(args);
        this.getLog().info((CharSequence)("Running: " + StringUtils.join(pb.command().iterator(), (String)" ")));
        try {
            String line;
            Process p = pb.start();
            BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = br.readLine()) != null) {
                this.getLog().info((CharSequence)line);
            }
            int ec = p.waitFor();
            if (ec != 0) {
                throw new DockerComposeException(IOUtil.toString((InputStream)p.getErrorStream()));
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage());
        }
    }

    private ProcessBuilder buildProcess(List<String> args) throws MojoExecutionException {
        List<String> command = this.buildCmd(args);
        ProcessBuilder pb = new ProcessBuilder(command).inheritIO();
        this.setEnvironment(pb);
        return pb;
    }

    private List<String> buildCmd(List<String> args) {
        ArrayList<String> composeFilePaths = new ArrayList<String>();
        if (this.composeFiles != null && !this.composeFiles.isEmpty()) {
            this.composeFiles.stream().map(x$0 -> Paths.get(x$0, new String[0])).map(Path::toString).forEachOrdered(composeFilePaths::add);
        } else {
            composeFilePaths.add(Paths.get(this.composeFile, new String[0]).toString());
        }
        this.getLog().info((CharSequence)("Docker Compose Files: " + String.join((CharSequence)", ", composeFilePaths)));
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("docker-compose");
        composeFilePaths.forEach(composeFilePath -> {
            cmd.add("-f");
            cmd.add((String)composeFilePath);
        });
        if (this.verbose) {
            cmd.add("--verbose");
        }
        if (this.host != null) {
            cmd.add("-H");
            cmd.add(this.host);
        }
        if (this.projectName != null) {
            cmd.add("-p");
            cmd.add(this.projectName);
        }
        cmd.addAll(args);
        return cmd;
    }

    private void setEnvironment(ProcessBuilder processBuilder) throws MojoExecutionException {
        Map<String, String> environment = processBuilder.environment();
        if (this.apiVersion != null) {
            this.getLog().info((CharSequence)("COMPOSE_API_VERSION: " + this.apiVersion));
            environment.put("COMPOSE_API_VERSION", this.apiVersion);
        }
        if (this.envVars != null && !this.envVars.isEmpty()) {
            this.envVars.forEach(environment::put);
        }
        if (this.envFile != null) {
            Properties properties = new Properties();
            try {
                properties.load(new FileInputStream(this.envFile));
                properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> environment.put(k.toString(), v.toString())));
            }
            catch (IOException e) {
                throw new MojoExecutionException(e.getMessage());
            }
        }
        if (null != this.envVars) {
            this.envVars.forEach((name, value) -> {
                this.getLog().info((CharSequence)String.format("%s: %s", name, value));
                environment.put((String)name, (String)value);
            });
        }
    }

    static enum Command {
        UP("up"),
        DOWN("down"),
        STOP("stop"),
        PULL("pull"),
        PUSH("push"),
        BUILD("build"),
        RESTART("restart");

        private String value;

        private Command(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

