/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.docusign.esign.model.AccountSettingsInformation;
import com.docusign.esign.model.BrandsResponse;
import com.docusign.esign.model.RecipientDomain;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@Schema(description="Contains account Information.")
public class AccountInformation {
    @JsonProperty(value="accountIdGuid")
    private String accountIdGuid = null;
    @JsonProperty(value="accountName")
    private String accountName = null;
    @JsonProperty(value="accountSettings")
    private AccountSettingsInformation accountSettings = null;
    @JsonProperty(value="allowTransactionRooms")
    private String allowTransactionRooms = null;
    @JsonProperty(value="billingPeriodDaysRemaining")
    private String billingPeriodDaysRemaining = null;
    @JsonProperty(value="billingPeriodEndDate")
    private String billingPeriodEndDate = null;
    @JsonProperty(value="billingPeriodEnvelopesAllowed")
    private String billingPeriodEnvelopesAllowed = null;
    @JsonProperty(value="billingPeriodEnvelopesSent")
    private String billingPeriodEnvelopesSent = null;
    @JsonProperty(value="billingPeriodStartDate")
    private String billingPeriodStartDate = null;
    @JsonProperty(value="billingProfile")
    private String billingProfile = null;
    @JsonProperty(value="brands")
    private BrandsResponse brands = null;
    @JsonProperty(value="canUpgrade")
    private String canUpgrade = null;
    @JsonProperty(value="connectPermission")
    private String connectPermission = null;
    @JsonProperty(value="createdDate")
    private String createdDate = null;
    @JsonProperty(value="currencyCode")
    private String currencyCode = null;
    @JsonProperty(value="currentPlanId")
    private String currentPlanId = null;
    @JsonProperty(value="displayApplianceStartUrl")
    private String displayApplianceStartUrl = null;
    @JsonProperty(value="displayApplianceUrl")
    private String displayApplianceUrl = null;
    @JsonProperty(value="distributorCode")
    private String distributorCode = null;
    @JsonProperty(value="docuSignLandingUrl")
    private String docuSignLandingUrl = null;
    @JsonProperty(value="dssValues")
    private Map<String, String> dssValues = null;
    @JsonProperty(value="envelopeSendingBlocked")
    private String envelopeSendingBlocked = null;
    @JsonProperty(value="envelopeUnitPrice")
    private String envelopeUnitPrice = null;
    @JsonProperty(value="externalAccountId")
    private String externalAccountId = null;
    @JsonProperty(value="forgottenPasswordQuestionsCount")
    private String forgottenPasswordQuestionsCount = null;
    @JsonProperty(value="isDowngrade")
    private String isDowngrade = null;
    @JsonProperty(value="paymentMethod")
    private String paymentMethod = null;
    @JsonProperty(value="planClassification")
    private String planClassification = null;
    @JsonProperty(value="planEndDate")
    private String planEndDate = null;
    @JsonProperty(value="planName")
    private String planName = null;
    @JsonProperty(value="planStartDate")
    private String planStartDate = null;
    @JsonProperty(value="recipientDomains")
    private List<RecipientDomain> recipientDomains = null;
    @JsonProperty(value="seatsAllowed")
    private String seatsAllowed = null;
    @JsonProperty(value="seatsInUse")
    private String seatsInUse = null;
    @JsonProperty(value="status21CFRPart11")
    private String status21CFRPart11 = null;
    @JsonProperty(value="suspensionDate")
    private String suspensionDate = null;
    @JsonProperty(value="suspensionStatus")
    private String suspensionStatus = null;
    @JsonProperty(value="useDisplayAppliance")
    private Boolean useDisplayAppliance = null;

    public AccountInformation accountIdGuid(String accountIdGuid) {
        this.accountIdGuid = accountIdGuid;
        return this;
    }

    @Schema(description="The GUID associated with the account ID.")
    public String getAccountIdGuid() {
        return this.accountIdGuid;
    }

    public void setAccountIdGuid(String accountIdGuid) {
        this.accountIdGuid = accountIdGuid;
    }

    public AccountInformation accountName(String accountName) {
        this.accountName = accountName;
        return this;
    }

    @Schema(description="The name of the current account.")
    public String getAccountName() {
        return this.accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public AccountInformation accountSettings(AccountSettingsInformation accountSettings) {
        this.accountSettings = accountSettings;
        return this;
    }

    @Schema(description="The list of account settings. These determine the features available for the account. Note that some features are determined by the plan used to create the account, and cannot be overridden.")
    public AccountSettingsInformation getAccountSettings() {
        return this.accountSettings;
    }

    public void setAccountSettings(AccountSettingsInformation accountSettings) {
        this.accountSettings = accountSettings;
    }

    public AccountInformation allowTransactionRooms(String allowTransactionRooms) {
        this.allowTransactionRooms = allowTransactionRooms;
        return this;
    }

    @Schema(description="When set to **true**, the transaction rooms feature exposed through the Workspaces API is enabled.")
    public String getAllowTransactionRooms() {
        return this.allowTransactionRooms;
    }

    public void setAllowTransactionRooms(String allowTransactionRooms) {
        this.allowTransactionRooms = allowTransactionRooms;
    }

    public AccountInformation billingPeriodDaysRemaining(String billingPeriodDaysRemaining) {
        this.billingPeriodDaysRemaining = billingPeriodDaysRemaining;
        return this;
    }

    @Schema(description="Reserved: TBD")
    public String getBillingPeriodDaysRemaining() {
        return this.billingPeriodDaysRemaining;
    }

    public void setBillingPeriodDaysRemaining(String billingPeriodDaysRemaining) {
        this.billingPeriodDaysRemaining = billingPeriodDaysRemaining;
    }

    public AccountInformation billingPeriodEndDate(String billingPeriodEndDate) {
        this.billingPeriodEndDate = billingPeriodEndDate;
        return this;
    }

    @Schema(description="Reserved: TBD")
    public String getBillingPeriodEndDate() {
        return this.billingPeriodEndDate;
    }

    public void setBillingPeriodEndDate(String billingPeriodEndDate) {
        this.billingPeriodEndDate = billingPeriodEndDate;
    }

    public AccountInformation billingPeriodEnvelopesAllowed(String billingPeriodEnvelopesAllowed) {
        this.billingPeriodEnvelopesAllowed = billingPeriodEnvelopesAllowed;
        return this;
    }

    @Schema(description="Reserved: TBD")
    public String getBillingPeriodEnvelopesAllowed() {
        return this.billingPeriodEnvelopesAllowed;
    }

    public void setBillingPeriodEnvelopesAllowed(String billingPeriodEnvelopesAllowed) {
        this.billingPeriodEnvelopesAllowed = billingPeriodEnvelopesAllowed;
    }

    public AccountInformation billingPeriodEnvelopesSent(String billingPeriodEnvelopesSent) {
        this.billingPeriodEnvelopesSent = billingPeriodEnvelopesSent;
        return this;
    }

    @Schema(description="Reserved: TBD")
    public String getBillingPeriodEnvelopesSent() {
        return this.billingPeriodEnvelopesSent;
    }

    public void setBillingPeriodEnvelopesSent(String billingPeriodEnvelopesSent) {
        this.billingPeriodEnvelopesSent = billingPeriodEnvelopesSent;
    }

    public AccountInformation billingPeriodStartDate(String billingPeriodStartDate) {
        this.billingPeriodStartDate = billingPeriodStartDate;
        return this;
    }

    @Schema(description="Reserved: TBD")
    public String getBillingPeriodStartDate() {
        return this.billingPeriodStartDate;
    }

    public void setBillingPeriodStartDate(String billingPeriodStartDate) {
        this.billingPeriodStartDate = billingPeriodStartDate;
    }

    public AccountInformation billingProfile(String billingProfile) {
        this.billingProfile = billingProfile;
        return this;
    }

    @Schema(description="Reserved: TBD")
    public String getBillingProfile() {
        return this.billingProfile;
    }

    public void setBillingProfile(String billingProfile) {
        this.billingProfile = billingProfile;
    }

    public AccountInformation brands(BrandsResponse brands) {
        this.brands = brands;
        return this;
    }

    @Schema(description="")
    public BrandsResponse getBrands() {
        return this.brands;
    }

    public void setBrands(BrandsResponse brands) {
        this.brands = brands;
    }

    public AccountInformation canUpgrade(String canUpgrade) {
        this.canUpgrade = canUpgrade;
        return this;
    }

    @Schema(description="When set to **true**, specifies that you can upgrade the account through the API.")
    public String getCanUpgrade() {
        return this.canUpgrade;
    }

    public void setCanUpgrade(String canUpgrade) {
        this.canUpgrade = canUpgrade;
    }

    public AccountInformation connectPermission(String connectPermission) {
        this.connectPermission = connectPermission;
        return this;
    }

    @Schema(description="")
    public String getConnectPermission() {
        return this.connectPermission;
    }

    public void setConnectPermission(String connectPermission) {
        this.connectPermission = connectPermission;
    }

    public AccountInformation createdDate(String createdDate) {
        this.createdDate = createdDate;
        return this;
    }

    @Schema(description="")
    public String getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(String createdDate) {
        this.createdDate = createdDate;
    }

    public AccountInformation currencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
        return this;
    }

    @Schema(description="Specifies the ISO currency code for the account.")
    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public AccountInformation currentPlanId(String currentPlanId) {
        this.currentPlanId = currentPlanId;
        return this;
    }

    @Schema(description="Identifies the plan that was used create this account.")
    public String getCurrentPlanId() {
        return this.currentPlanId;
    }

    public void setCurrentPlanId(String currentPlanId) {
        this.currentPlanId = currentPlanId;
    }

    public AccountInformation displayApplianceStartUrl(String displayApplianceStartUrl) {
        this.displayApplianceStartUrl = displayApplianceStartUrl;
        return this;
    }

    @Schema(description="")
    public String getDisplayApplianceStartUrl() {
        return this.displayApplianceStartUrl;
    }

    public void setDisplayApplianceStartUrl(String displayApplianceStartUrl) {
        this.displayApplianceStartUrl = displayApplianceStartUrl;
    }

    public AccountInformation displayApplianceUrl(String displayApplianceUrl) {
        this.displayApplianceUrl = displayApplianceUrl;
        return this;
    }

    @Schema(description="")
    public String getDisplayApplianceUrl() {
        return this.displayApplianceUrl;
    }

    public void setDisplayApplianceUrl(String displayApplianceUrl) {
        this.displayApplianceUrl = displayApplianceUrl;
    }

    public AccountInformation distributorCode(String distributorCode) {
        this.distributorCode = distributorCode;
        return this;
    }

    @Schema(description="The code that identifies the billing plan groups and plans for the new account.")
    public String getDistributorCode() {
        return this.distributorCode;
    }

    public void setDistributorCode(String distributorCode) {
        this.distributorCode = distributorCode;
    }

    public AccountInformation docuSignLandingUrl(String docuSignLandingUrl) {
        this.docuSignLandingUrl = docuSignLandingUrl;
        return this;
    }

    @Schema(description="")
    public String getDocuSignLandingUrl() {
        return this.docuSignLandingUrl;
    }

    public void setDocuSignLandingUrl(String docuSignLandingUrl) {
        this.docuSignLandingUrl = docuSignLandingUrl;
    }

    public AccountInformation dssValues(Map<String, String> dssValues) {
        this.dssValues = dssValues;
        return this;
    }

    public AccountInformation putDssValuesItem(String key, String dssValuesItem) {
        if (this.dssValues == null) {
            this.dssValues = new HashMap<String, String>();
        }
        this.dssValues.put(key, dssValuesItem);
        return this;
    }

    @Schema(description="")
    public Map<String, String> getDssValues() {
        return this.dssValues;
    }

    public void setDssValues(Map<String, String> dssValues) {
        this.dssValues = dssValues;
    }

    public AccountInformation envelopeSendingBlocked(String envelopeSendingBlocked) {
        this.envelopeSendingBlocked = envelopeSendingBlocked;
        return this;
    }

    @Schema(description="")
    public String getEnvelopeSendingBlocked() {
        return this.envelopeSendingBlocked;
    }

    public void setEnvelopeSendingBlocked(String envelopeSendingBlocked) {
        this.envelopeSendingBlocked = envelopeSendingBlocked;
    }

    public AccountInformation envelopeUnitPrice(String envelopeUnitPrice) {
        this.envelopeUnitPrice = envelopeUnitPrice;
        return this;
    }

    @Schema(description="")
    public String getEnvelopeUnitPrice() {
        return this.envelopeUnitPrice;
    }

    public void setEnvelopeUnitPrice(String envelopeUnitPrice) {
        this.envelopeUnitPrice = envelopeUnitPrice;
    }

    public AccountInformation externalAccountId(String externalAccountId) {
        this.externalAccountId = externalAccountId;
        return this;
    }

    @Schema(description="")
    public String getExternalAccountId() {
        return this.externalAccountId;
    }

    public void setExternalAccountId(String externalAccountId) {
        this.externalAccountId = externalAccountId;
    }

    public AccountInformation forgottenPasswordQuestionsCount(String forgottenPasswordQuestionsCount) {
        this.forgottenPasswordQuestionsCount = forgottenPasswordQuestionsCount;
        return this;
    }

    @Schema(description=" A complex element that contains up to four Question/Answer pairs for forgotten password information for a user.")
    public String getForgottenPasswordQuestionsCount() {
        return this.forgottenPasswordQuestionsCount;
    }

    public void setForgottenPasswordQuestionsCount(String forgottenPasswordQuestionsCount) {
        this.forgottenPasswordQuestionsCount = forgottenPasswordQuestionsCount;
    }

    public AccountInformation isDowngrade(String isDowngrade) {
        this.isDowngrade = isDowngrade;
        return this;
    }

    @Schema(description="")
    public String getIsDowngrade() {
        return this.isDowngrade;
    }

    public void setIsDowngrade(String isDowngrade) {
        this.isDowngrade = isDowngrade;
    }

    public AccountInformation paymentMethod(String paymentMethod) {
        this.paymentMethod = paymentMethod;
        return this;
    }

    @Schema(description="")
    public String getPaymentMethod() {
        return this.paymentMethod;
    }

    public void setPaymentMethod(String paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public AccountInformation planClassification(String planClassification) {
        this.planClassification = planClassification;
        return this;
    }

    @Schema(description="Identifies the type of plan. Examples include Business, Corporate, Enterprise, Free.")
    public String getPlanClassification() {
        return this.planClassification;
    }

    public void setPlanClassification(String planClassification) {
        this.planClassification = planClassification;
    }

    public AccountInformation planEndDate(String planEndDate) {
        this.planEndDate = planEndDate;
        return this;
    }

    @Schema(description="The date that the current plan will end.")
    public String getPlanEndDate() {
        return this.planEndDate;
    }

    public void setPlanEndDate(String planEndDate) {
        this.planEndDate = planEndDate;
    }

    public AccountInformation planName(String planName) {
        this.planName = planName;
        return this;
    }

    @Schema(description="The name of the Billing Plan.")
    public String getPlanName() {
        return this.planName;
    }

    public void setPlanName(String planName) {
        this.planName = planName;
    }

    public AccountInformation planStartDate(String planStartDate) {
        this.planStartDate = planStartDate;
        return this;
    }

    @Schema(description="The date that the Account started using the current plan.")
    public String getPlanStartDate() {
        return this.planStartDate;
    }

    public void setPlanStartDate(String planStartDate) {
        this.planStartDate = planStartDate;
    }

    public AccountInformation recipientDomains(List<RecipientDomain> recipientDomains) {
        this.recipientDomains = recipientDomains;
        return this;
    }

    public AccountInformation addRecipientDomainsItem(RecipientDomain recipientDomainsItem) {
        if (this.recipientDomains == null) {
            this.recipientDomains = new ArrayList<RecipientDomain>();
        }
        this.recipientDomains.add(recipientDomainsItem);
        return this;
    }

    @Schema(description="")
    public List<RecipientDomain> getRecipientDomains() {
        return this.recipientDomains;
    }

    public void setRecipientDomains(List<RecipientDomain> recipientDomains) {
        this.recipientDomains = recipientDomains;
    }

    public AccountInformation seatsAllowed(String seatsAllowed) {
        this.seatsAllowed = seatsAllowed;
        return this;
    }

    @Schema(description="")
    public String getSeatsAllowed() {
        return this.seatsAllowed;
    }

    public void setSeatsAllowed(String seatsAllowed) {
        this.seatsAllowed = seatsAllowed;
    }

    public AccountInformation seatsInUse(String seatsInUse) {
        this.seatsInUse = seatsInUse;
        return this;
    }

    @Schema(description="")
    public String getSeatsInUse() {
        return this.seatsInUse;
    }

    public void setSeatsInUse(String seatsInUse) {
        this.seatsInUse = seatsInUse;
    }

    public AccountInformation status21CFRPart11(String status21CFRPart11) {
        this.status21CFRPart11 = status21CFRPart11;
        return this;
    }

    @Schema(description="")
    public String getStatus21CFRPart11() {
        return this.status21CFRPart11;
    }

    public void setStatus21CFRPart11(String status21CFRPart11) {
        this.status21CFRPart11 = status21CFRPart11;
    }

    public AccountInformation suspensionDate(String suspensionDate) {
        this.suspensionDate = suspensionDate;
        return this;
    }

    @Schema(description="")
    public String getSuspensionDate() {
        return this.suspensionDate;
    }

    public void setSuspensionDate(String suspensionDate) {
        this.suspensionDate = suspensionDate;
    }

    public AccountInformation suspensionStatus(String suspensionStatus) {
        this.suspensionStatus = suspensionStatus;
        return this;
    }

    @Schema(description="")
    public String getSuspensionStatus() {
        return this.suspensionStatus;
    }

    public void setSuspensionStatus(String suspensionStatus) {
        this.suspensionStatus = suspensionStatus;
    }

    public AccountInformation useDisplayAppliance(Boolean useDisplayAppliance) {
        this.useDisplayAppliance = useDisplayAppliance;
        return this;
    }

    @Schema(description="")
    public Boolean isUseDisplayAppliance() {
        return this.useDisplayAppliance;
    }

    public void setUseDisplayAppliance(Boolean useDisplayAppliance) {
        this.useDisplayAppliance = useDisplayAppliance;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountInformation accountInformation = (AccountInformation)o;
        return Objects.equals(this.accountIdGuid, accountInformation.accountIdGuid) && Objects.equals(this.accountName, accountInformation.accountName) && Objects.equals(this.accountSettings, accountInformation.accountSettings) && Objects.equals(this.allowTransactionRooms, accountInformation.allowTransactionRooms) && Objects.equals(this.billingPeriodDaysRemaining, accountInformation.billingPeriodDaysRemaining) && Objects.equals(this.billingPeriodEndDate, accountInformation.billingPeriodEndDate) && Objects.equals(this.billingPeriodEnvelopesAllowed, accountInformation.billingPeriodEnvelopesAllowed) && Objects.equals(this.billingPeriodEnvelopesSent, accountInformation.billingPeriodEnvelopesSent) && Objects.equals(this.billingPeriodStartDate, accountInformation.billingPeriodStartDate) && Objects.equals(this.billingProfile, accountInformation.billingProfile) && Objects.equals(this.brands, accountInformation.brands) && Objects.equals(this.canUpgrade, accountInformation.canUpgrade) && Objects.equals(this.connectPermission, accountInformation.connectPermission) && Objects.equals(this.createdDate, accountInformation.createdDate) && Objects.equals(this.currencyCode, accountInformation.currencyCode) && Objects.equals(this.currentPlanId, accountInformation.currentPlanId) && Objects.equals(this.displayApplianceStartUrl, accountInformation.displayApplianceStartUrl) && Objects.equals(this.displayApplianceUrl, accountInformation.displayApplianceUrl) && Objects.equals(this.distributorCode, accountInformation.distributorCode) && Objects.equals(this.docuSignLandingUrl, accountInformation.docuSignLandingUrl) && Objects.equals(this.dssValues, accountInformation.dssValues) && Objects.equals(this.envelopeSendingBlocked, accountInformation.envelopeSendingBlocked) && Objects.equals(this.envelopeUnitPrice, accountInformation.envelopeUnitPrice) && Objects.equals(this.externalAccountId, accountInformation.externalAccountId) && Objects.equals(this.forgottenPasswordQuestionsCount, accountInformation.forgottenPasswordQuestionsCount) && Objects.equals(this.isDowngrade, accountInformation.isDowngrade) && Objects.equals(this.paymentMethod, accountInformation.paymentMethod) && Objects.equals(this.planClassification, accountInformation.planClassification) && Objects.equals(this.planEndDate, accountInformation.planEndDate) && Objects.equals(this.planName, accountInformation.planName) && Objects.equals(this.planStartDate, accountInformation.planStartDate) && Objects.equals(this.recipientDomains, accountInformation.recipientDomains) && Objects.equals(this.seatsAllowed, accountInformation.seatsAllowed) && Objects.equals(this.seatsInUse, accountInformation.seatsInUse) && Objects.equals(this.status21CFRPart11, accountInformation.status21CFRPart11) && Objects.equals(this.suspensionDate, accountInformation.suspensionDate) && Objects.equals(this.suspensionStatus, accountInformation.suspensionStatus) && Objects.equals(this.useDisplayAppliance, accountInformation.useDisplayAppliance);
    }

    public int hashCode() {
        return Objects.hash(this.accountIdGuid, this.accountName, this.accountSettings, this.allowTransactionRooms, this.billingPeriodDaysRemaining, this.billingPeriodEndDate, this.billingPeriodEnvelopesAllowed, this.billingPeriodEnvelopesSent, this.billingPeriodStartDate, this.billingProfile, this.brands, this.canUpgrade, this.connectPermission, this.createdDate, this.currencyCode, this.currentPlanId, this.displayApplianceStartUrl, this.displayApplianceUrl, this.distributorCode, this.docuSignLandingUrl, this.dssValues, this.envelopeSendingBlocked, this.envelopeUnitPrice, this.externalAccountId, this.forgottenPasswordQuestionsCount, this.isDowngrade, this.paymentMethod, this.planClassification, this.planEndDate, this.planName, this.planStartDate, this.recipientDomains, this.seatsAllowed, this.seatsInUse, this.status21CFRPart11, this.suspensionDate, this.suspensionStatus, this.useDisplayAppliance);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccountInformation {\n");
        sb.append("    accountIdGuid: ").append(this.toIndentedString(this.accountIdGuid)).append("\n");
        sb.append("    accountName: ").append(this.toIndentedString(this.accountName)).append("\n");
        sb.append("    accountSettings: ").append(this.toIndentedString(this.accountSettings)).append("\n");
        sb.append("    allowTransactionRooms: ").append(this.toIndentedString(this.allowTransactionRooms)).append("\n");
        sb.append("    billingPeriodDaysRemaining: ").append(this.toIndentedString(this.billingPeriodDaysRemaining)).append("\n");
        sb.append("    billingPeriodEndDate: ").append(this.toIndentedString(this.billingPeriodEndDate)).append("\n");
        sb.append("    billingPeriodEnvelopesAllowed: ").append(this.toIndentedString(this.billingPeriodEnvelopesAllowed)).append("\n");
        sb.append("    billingPeriodEnvelopesSent: ").append(this.toIndentedString(this.billingPeriodEnvelopesSent)).append("\n");
        sb.append("    billingPeriodStartDate: ").append(this.toIndentedString(this.billingPeriodStartDate)).append("\n");
        sb.append("    billingProfile: ").append(this.toIndentedString(this.billingProfile)).append("\n");
        sb.append("    brands: ").append(this.toIndentedString(this.brands)).append("\n");
        sb.append("    canUpgrade: ").append(this.toIndentedString(this.canUpgrade)).append("\n");
        sb.append("    connectPermission: ").append(this.toIndentedString(this.connectPermission)).append("\n");
        sb.append("    createdDate: ").append(this.toIndentedString(this.createdDate)).append("\n");
        sb.append("    currencyCode: ").append(this.toIndentedString(this.currencyCode)).append("\n");
        sb.append("    currentPlanId: ").append(this.toIndentedString(this.currentPlanId)).append("\n");
        sb.append("    displayApplianceStartUrl: ").append(this.toIndentedString(this.displayApplianceStartUrl)).append("\n");
        sb.append("    displayApplianceUrl: ").append(this.toIndentedString(this.displayApplianceUrl)).append("\n");
        sb.append("    distributorCode: ").append(this.toIndentedString(this.distributorCode)).append("\n");
        sb.append("    docuSignLandingUrl: ").append(this.toIndentedString(this.docuSignLandingUrl)).append("\n");
        sb.append("    dssValues: ").append(this.toIndentedString(this.dssValues)).append("\n");
        sb.append("    envelopeSendingBlocked: ").append(this.toIndentedString(this.envelopeSendingBlocked)).append("\n");
        sb.append("    envelopeUnitPrice: ").append(this.toIndentedString(this.envelopeUnitPrice)).append("\n");
        sb.append("    externalAccountId: ").append(this.toIndentedString(this.externalAccountId)).append("\n");
        sb.append("    forgottenPasswordQuestionsCount: ").append(this.toIndentedString(this.forgottenPasswordQuestionsCount)).append("\n");
        sb.append("    isDowngrade: ").append(this.toIndentedString(this.isDowngrade)).append("\n");
        sb.append("    paymentMethod: ").append(this.toIndentedString(this.paymentMethod)).append("\n");
        sb.append("    planClassification: ").append(this.toIndentedString(this.planClassification)).append("\n");
        sb.append("    planEndDate: ").append(this.toIndentedString(this.planEndDate)).append("\n");
        sb.append("    planName: ").append(this.toIndentedString(this.planName)).append("\n");
        sb.append("    planStartDate: ").append(this.toIndentedString(this.planStartDate)).append("\n");
        sb.append("    recipientDomains: ").append(this.toIndentedString(this.recipientDomains)).append("\n");
        sb.append("    seatsAllowed: ").append(this.toIndentedString(this.seatsAllowed)).append("\n");
        sb.append("    seatsInUse: ").append(this.toIndentedString(this.seatsInUse)).append("\n");
        sb.append("    status21CFRPart11: ").append(this.toIndentedString(this.status21CFRPart11)).append("\n");
        sb.append("    suspensionDate: ").append(this.toIndentedString(this.suspensionDate)).append("\n");
        sb.append("    suspensionStatus: ").append(this.toIndentedString(this.suspensionStatus)).append("\n");
        sb.append("    useDisplayAppliance: ").append(this.toIndentedString(this.useDisplayAppliance)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

