/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.docusign.esign.model.AddOn;
import com.docusign.esign.model.FeatureSet;
import com.docusign.esign.model.RecipientDomain;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(description="An object used to identify the features and attributes of the account being created.")
public class PlanInformation {
    @JsonProperty(value="addOns")
    private List<AddOn> addOns = null;
    @JsonProperty(value="currencyCode")
    private String currencyCode = null;
    @JsonProperty(value="freeTrialDaysOverride")
    private String freeTrialDaysOverride = null;
    @JsonProperty(value="planFeatureSets")
    private List<FeatureSet> planFeatureSets = null;
    @JsonProperty(value="planId")
    private String planId = null;
    @JsonProperty(value="recipientDomains")
    private List<RecipientDomain> recipientDomains = null;

    public PlanInformation addOns(List<AddOn> addOns) {
        this.addOns = addOns;
        return this;
    }

    public PlanInformation addAddOnsItem(AddOn addOnsItem) {
        if (this.addOns == null) {
            this.addOns = new ArrayList<AddOn>();
        }
        this.addOns.add(addOnsItem);
        return this;
    }

    @Schema(description="Reserved:")
    public List<AddOn> getAddOns() {
        return this.addOns;
    }

    public void setAddOns(List<AddOn> addOns) {
        this.addOns = addOns;
    }

    public PlanInformation currencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
        return this;
    }

    @Schema(description="Specifies the ISO currency code for the account.")
    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public PlanInformation freeTrialDaysOverride(String freeTrialDaysOverride) {
        this.freeTrialDaysOverride = freeTrialDaysOverride;
        return this;
    }

    @Schema(description="Reserved for DocuSign use only.")
    public String getFreeTrialDaysOverride() {
        return this.freeTrialDaysOverride;
    }

    public void setFreeTrialDaysOverride(String freeTrialDaysOverride) {
        this.freeTrialDaysOverride = freeTrialDaysOverride;
    }

    public PlanInformation planFeatureSets(List<FeatureSet> planFeatureSets) {
        this.planFeatureSets = planFeatureSets;
        return this;
    }

    public PlanInformation addPlanFeatureSetsItem(FeatureSet planFeatureSetsItem) {
        if (this.planFeatureSets == null) {
            this.planFeatureSets = new ArrayList<FeatureSet>();
        }
        this.planFeatureSets.add(planFeatureSetsItem);
        return this;
    }

    @Schema(description="A complex type that sets the feature sets for the account.")
    public List<FeatureSet> getPlanFeatureSets() {
        return this.planFeatureSets;
    }

    public void setPlanFeatureSets(List<FeatureSet> planFeatureSets) {
        this.planFeatureSets = planFeatureSets;
    }

    public PlanInformation planId(String planId) {
        this.planId = planId;
        return this;
    }

    @Schema(description="The DocuSign Plan ID for the account.")
    public String getPlanId() {
        return this.planId;
    }

    public void setPlanId(String planId) {
        this.planId = planId;
    }

    public PlanInformation recipientDomains(List<RecipientDomain> recipientDomains) {
        this.recipientDomains = recipientDomains;
        return this;
    }

    public PlanInformation addRecipientDomainsItem(RecipientDomain recipientDomainsItem) {
        if (this.recipientDomains == null) {
            this.recipientDomains = new ArrayList<RecipientDomain>();
        }
        this.recipientDomains.add(recipientDomainsItem);
        return this;
    }

    @Schema(description="")
    public List<RecipientDomain> getRecipientDomains() {
        return this.recipientDomains;
    }

    public void setRecipientDomains(List<RecipientDomain> recipientDomains) {
        this.recipientDomains = recipientDomains;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlanInformation planInformation = (PlanInformation)o;
        return Objects.equals(this.addOns, planInformation.addOns) && Objects.equals(this.currencyCode, planInformation.currencyCode) && Objects.equals(this.freeTrialDaysOverride, planInformation.freeTrialDaysOverride) && Objects.equals(this.planFeatureSets, planInformation.planFeatureSets) && Objects.equals(this.planId, planInformation.planId) && Objects.equals(this.recipientDomains, planInformation.recipientDomains);
    }

    public int hashCode() {
        return Objects.hash(this.addOns, this.currencyCode, this.freeTrialDaysOverride, this.planFeatureSets, this.planId, this.recipientDomains);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PlanInformation {\n");
        sb.append("    addOns: ").append(this.toIndentedString(this.addOns)).append("\n");
        sb.append("    currencyCode: ").append(this.toIndentedString(this.currencyCode)).append("\n");
        sb.append("    freeTrialDaysOverride: ").append(this.toIndentedString(this.freeTrialDaysOverride)).append("\n");
        sb.append("    planFeatureSets: ").append(this.toIndentedString(this.planFeatureSets)).append("\n");
        sb.append("    planId: ").append(this.toIndentedString(this.planId)).append("\n");
        sb.append("    recipientDomains: ").append(this.toIndentedString(this.recipientDomains)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

