/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Contains the settings for the email notifications that senders receive about the envelopes that they send.")
public class SenderEmailNotifications {
    @JsonProperty(value="changedSigner")
    private String changedSigner = null;
    @JsonProperty(value="clickwrapResponsesLimitNotificationEmail")
    private String clickwrapResponsesLimitNotificationEmail = null;
    @JsonProperty(value="commentsOnlyPrivateAndMention")
    private String commentsOnlyPrivateAndMention = null;
    @JsonProperty(value="commentsReceiveAll")
    private String commentsReceiveAll = null;
    @JsonProperty(value="deliveryFailed")
    private String deliveryFailed = null;
    @JsonProperty(value="envelopeComplete")
    private String envelopeComplete = null;
    @JsonProperty(value="offlineSigningFailed")
    private String offlineSigningFailed = null;
    @JsonProperty(value="powerformResponsesLimitNotificationEmail")
    private String powerformResponsesLimitNotificationEmail = null;
    @JsonProperty(value="purgeDocuments")
    private String purgeDocuments = null;
    @JsonProperty(value="recipientViewed")
    private String recipientViewed = null;
    @JsonProperty(value="senderEnvelopeDeclined")
    private String senderEnvelopeDeclined = null;
    @JsonProperty(value="withdrawnConsent")
    private String withdrawnConsent = null;

    public SenderEmailNotifications changedSigner(String changedSigner) {
        this.changedSigner = changedSigner;
        return this;
    }

    @Schema(description="When set to **true**, the sender receives notification if the signer changes.")
    public String getChangedSigner() {
        return this.changedSigner;
    }

    public void setChangedSigner(String changedSigner) {
        this.changedSigner = changedSigner;
    }

    public SenderEmailNotifications clickwrapResponsesLimitNotificationEmail(String clickwrapResponsesLimitNotificationEmail) {
        this.clickwrapResponsesLimitNotificationEmail = clickwrapResponsesLimitNotificationEmail;
        return this;
    }

    @Schema(description="")
    public String getClickwrapResponsesLimitNotificationEmail() {
        return this.clickwrapResponsesLimitNotificationEmail;
    }

    public void setClickwrapResponsesLimitNotificationEmail(String clickwrapResponsesLimitNotificationEmail) {
        this.clickwrapResponsesLimitNotificationEmail = clickwrapResponsesLimitNotificationEmail;
    }

    public SenderEmailNotifications commentsOnlyPrivateAndMention(String commentsOnlyPrivateAndMention) {
        this.commentsOnlyPrivateAndMention = commentsOnlyPrivateAndMention;
        return this;
    }

    @Schema(description="")
    public String getCommentsOnlyPrivateAndMention() {
        return this.commentsOnlyPrivateAndMention;
    }

    public void setCommentsOnlyPrivateAndMention(String commentsOnlyPrivateAndMention) {
        this.commentsOnlyPrivateAndMention = commentsOnlyPrivateAndMention;
    }

    public SenderEmailNotifications commentsReceiveAll(String commentsReceiveAll) {
        this.commentsReceiveAll = commentsReceiveAll;
        return this;
    }

    @Schema(description="")
    public String getCommentsReceiveAll() {
        return this.commentsReceiveAll;
    }

    public void setCommentsReceiveAll(String commentsReceiveAll) {
        this.commentsReceiveAll = commentsReceiveAll;
    }

    public SenderEmailNotifications deliveryFailed(String deliveryFailed) {
        this.deliveryFailed = deliveryFailed;
        return this;
    }

    @Schema(description="When set to **true**, the sender receives notification if the delivery of the envelope fails.")
    public String getDeliveryFailed() {
        return this.deliveryFailed;
    }

    public void setDeliveryFailed(String deliveryFailed) {
        this.deliveryFailed = deliveryFailed;
    }

    public SenderEmailNotifications envelopeComplete(String envelopeComplete) {
        this.envelopeComplete = envelopeComplete;
        return this;
    }

    @Schema(description="When set to **true**, the user receives notification that the envelope has been completed.")
    public String getEnvelopeComplete() {
        return this.envelopeComplete;
    }

    public void setEnvelopeComplete(String envelopeComplete) {
        this.envelopeComplete = envelopeComplete;
    }

    public SenderEmailNotifications offlineSigningFailed(String offlineSigningFailed) {
        this.offlineSigningFailed = offlineSigningFailed;
        return this;
    }

    @Schema(description="When set to **true**, the user receives notification if the offline signing failed.")
    public String getOfflineSigningFailed() {
        return this.offlineSigningFailed;
    }

    public void setOfflineSigningFailed(String offlineSigningFailed) {
        this.offlineSigningFailed = offlineSigningFailed;
    }

    public SenderEmailNotifications powerformResponsesLimitNotificationEmail(String powerformResponsesLimitNotificationEmail) {
        this.powerformResponsesLimitNotificationEmail = powerformResponsesLimitNotificationEmail;
        return this;
    }

    @Schema(description="")
    public String getPowerformResponsesLimitNotificationEmail() {
        return this.powerformResponsesLimitNotificationEmail;
    }

    public void setPowerformResponsesLimitNotificationEmail(String powerformResponsesLimitNotificationEmail) {
        this.powerformResponsesLimitNotificationEmail = powerformResponsesLimitNotificationEmail;
    }

    public SenderEmailNotifications purgeDocuments(String purgeDocuments) {
        this.purgeDocuments = purgeDocuments;
        return this;
    }

    @Schema(description="")
    public String getPurgeDocuments() {
        return this.purgeDocuments;
    }

    public void setPurgeDocuments(String purgeDocuments) {
        this.purgeDocuments = purgeDocuments;
    }

    public SenderEmailNotifications recipientViewed(String recipientViewed) {
        this.recipientViewed = recipientViewed;
        return this;
    }

    @Schema(description="When set to **true**, the sender receives notification that the recipient viewed the enveloper.")
    public String getRecipientViewed() {
        return this.recipientViewed;
    }

    public void setRecipientViewed(String recipientViewed) {
        this.recipientViewed = recipientViewed;
    }

    public SenderEmailNotifications senderEnvelopeDeclined(String senderEnvelopeDeclined) {
        this.senderEnvelopeDeclined = senderEnvelopeDeclined;
        return this;
    }

    @Schema(description="")
    public String getSenderEnvelopeDeclined() {
        return this.senderEnvelopeDeclined;
    }

    public void setSenderEnvelopeDeclined(String senderEnvelopeDeclined) {
        this.senderEnvelopeDeclined = senderEnvelopeDeclined;
    }

    public SenderEmailNotifications withdrawnConsent(String withdrawnConsent) {
        this.withdrawnConsent = withdrawnConsent;
        return this;
    }

    @Schema(description="When set to **true**, the user receives notification if consent is withdrawn.")
    public String getWithdrawnConsent() {
        return this.withdrawnConsent;
    }

    public void setWithdrawnConsent(String withdrawnConsent) {
        this.withdrawnConsent = withdrawnConsent;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SenderEmailNotifications senderEmailNotifications = (SenderEmailNotifications)o;
        return Objects.equals(this.changedSigner, senderEmailNotifications.changedSigner) && Objects.equals(this.clickwrapResponsesLimitNotificationEmail, senderEmailNotifications.clickwrapResponsesLimitNotificationEmail) && Objects.equals(this.commentsOnlyPrivateAndMention, senderEmailNotifications.commentsOnlyPrivateAndMention) && Objects.equals(this.commentsReceiveAll, senderEmailNotifications.commentsReceiveAll) && Objects.equals(this.deliveryFailed, senderEmailNotifications.deliveryFailed) && Objects.equals(this.envelopeComplete, senderEmailNotifications.envelopeComplete) && Objects.equals(this.offlineSigningFailed, senderEmailNotifications.offlineSigningFailed) && Objects.equals(this.powerformResponsesLimitNotificationEmail, senderEmailNotifications.powerformResponsesLimitNotificationEmail) && Objects.equals(this.purgeDocuments, senderEmailNotifications.purgeDocuments) && Objects.equals(this.recipientViewed, senderEmailNotifications.recipientViewed) && Objects.equals(this.senderEnvelopeDeclined, senderEmailNotifications.senderEnvelopeDeclined) && Objects.equals(this.withdrawnConsent, senderEmailNotifications.withdrawnConsent);
    }

    public int hashCode() {
        return Objects.hash(this.changedSigner, this.clickwrapResponsesLimitNotificationEmail, this.commentsOnlyPrivateAndMention, this.commentsReceiveAll, this.deliveryFailed, this.envelopeComplete, this.offlineSigningFailed, this.powerformResponsesLimitNotificationEmail, this.purgeDocuments, this.recipientViewed, this.senderEnvelopeDeclined, this.withdrawnConsent);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SenderEmailNotifications {\n");
        sb.append("    changedSigner: ").append(this.toIndentedString(this.changedSigner)).append("\n");
        sb.append("    clickwrapResponsesLimitNotificationEmail: ").append(this.toIndentedString(this.clickwrapResponsesLimitNotificationEmail)).append("\n");
        sb.append("    commentsOnlyPrivateAndMention: ").append(this.toIndentedString(this.commentsOnlyPrivateAndMention)).append("\n");
        sb.append("    commentsReceiveAll: ").append(this.toIndentedString(this.commentsReceiveAll)).append("\n");
        sb.append("    deliveryFailed: ").append(this.toIndentedString(this.deliveryFailed)).append("\n");
        sb.append("    envelopeComplete: ").append(this.toIndentedString(this.envelopeComplete)).append("\n");
        sb.append("    offlineSigningFailed: ").append(this.toIndentedString(this.offlineSigningFailed)).append("\n");
        sb.append("    powerformResponsesLimitNotificationEmail: ").append(this.toIndentedString(this.powerformResponsesLimitNotificationEmail)).append("\n");
        sb.append("    purgeDocuments: ").append(this.toIndentedString(this.purgeDocuments)).append("\n");
        sb.append("    recipientViewed: ").append(this.toIndentedString(this.recipientViewed)).append("\n");
        sb.append("    senderEnvelopeDeclined: ").append(this.toIndentedString(this.senderEnvelopeDeclined)).append("\n");
        sb.append("    withdrawnConsent: ").append(this.toIndentedString(this.withdrawnConsent)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

