/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.file.util;

import com.dynatrace.file.util.FilePoller;
import com.dynatrace.file.util.PollBasedFilePoller;
import com.dynatrace.file.util.WatchServiceBasedFilePoller;
import java.io.IOException;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.logging.Level;
import java.util.logging.Logger;

class FilePollerFactory {
    private static final Logger logger = Logger.getLogger(FilePollerFactory.class.getName());
    private static final boolean IS_MAC_OS = System.getProperty("os.name", "").toLowerCase().contains("mac");

    private FilePollerFactory() {
    }

    static FilePoller getDefault(String fileName, Duration pollInterval) throws IOException {
        if (IS_MAC_OS) {
            logger.fine("Running on macOS");
            if (pollInterval == null) {
                pollInterval = Duration.ofSeconds(60L);
            }
            return FilePollerFactory.getPollBased(fileName, pollInterval);
        }
        return FilePollerFactory.getWatchServiceBased(fileName);
    }

    static PollBasedFilePoller getPollBased(String fileName, Duration pollInterval) {
        if (logger.isLoggable(Level.INFO) && pollInterval != null) {
            logger.info(String.format("Setting up poll-based FilePoller with poll interval %dms", pollInterval.toMillis()));
        }
        return new PollBasedFilePoller(Paths.get(fileName, new String[0]), pollInterval);
    }

    static WatchServiceBasedFilePoller getWatchServiceBased(String fileName) throws IOException {
        logger.info("Setting up WatchService-based FilePoller");
        return new WatchServiceBasedFilePoller(Paths.get(fileName, new String[0]));
    }
}

