/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.file.util;

import com.dynatrace.file.util.FilePoller;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Collections;
import java.util.List;

class WatchServiceBasedFilePoller
extends FilePoller {
    private final Path folder;
    private final WatchService watchService;

    public WatchServiceBasedFilePoller(Path absoluteFilename) throws IOException {
        super(absoluteFilename);
        this.folder = absoluteFilename.getParent();
        this.watchService = FileSystems.getDefault().newWatchService();
        this.folder.register(this.watchService, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_CREATE);
    }

    @Override
    public boolean fileContentsUpdated() {
        List<WatchEvent<?>> watchEvents = this.poll();
        for (WatchEvent<?> event : watchEvents) {
            Path filename = this.folder.resolve((Path)event.context()).toAbsolutePath();
            if (filename.compareTo(this.absoluteFilePath) != 0) continue;
            return true;
        }
        return false;
    }

    private List<WatchEvent<?>> poll() {
        WatchKey watchKey = this.watchService.poll();
        if (watchKey == null) {
            return Collections.emptyList();
        }
        List<WatchEvent<?>> watchEvents = watchKey.pollEvents();
        watchKey.reset();
        return watchEvents;
    }

    @Override
    public void close() throws IOException {
        this.watchService.close();
    }
}

