/*
 * Copyright 2012-2015 Ye Ding
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.dyngr.core.strategy;

import java.util.List;

import com.dyngr.core.Attempt;
import com.dyngr.core.StopStrategy;

/**
 * A stop strategy composited by a list of strategies and will stop if any of them to say stop.
 *
 * Created by dingye on 18/1/26.
 */
public class CompositeStopStrategy implements StopStrategy {
    private final List<StopStrategy> stopStrategies;

    public CompositeStopStrategy(List<StopStrategy> stopStrategies) {
        this.stopStrategies = stopStrategies;
    }

    public List<StopStrategy> getStopStrategies() {
        return stopStrategies;
    }

    @Override
    public boolean shouldStop(Attempt failedAttempt) {
        for (StopStrategy stopStrategy : stopStrategies) {
            if (stopStrategy.shouldStop(failedAttempt)) {
                return true;
            }
        }
        return false;
    }
}
