/*
 * Decompiled with CFR 0.152.
 */
package com.dyngr;

import com.dyngr.Poller;
import com.dyngr.concurrent.DirectExecutorService;
import com.dyngr.core.Attempt;
import com.dyngr.core.AttemptMaker;
import com.dyngr.core.DefaultPoller;
import com.dyngr.core.StopStrategies;
import com.dyngr.core.StopStrategy;
import com.dyngr.core.WaitStrategies;
import com.dyngr.core.WaitStrategy;
import com.dyngr.util.Preconditions;
import java.util.concurrent.ExecutorService;

public class PollerBuilder<V> {
    private AttemptMaker<V> attemptMaker;
    private Boolean stopIfException;
    private StopStrategy stopStrategy;
    private WaitStrategy waitStrategy;
    private ExecutorService executorService;

    public PollerBuilder<V> withWaitStrategy(WaitStrategy waitStrategy) {
        Preconditions.checkNotNull(waitStrategy, "waitStrategy should not be null");
        Preconditions.checkState(this.waitStrategy == null, "a waitStrategy has already been set %s", (Object)this.waitStrategy);
        this.waitStrategy = waitStrategy;
        return this;
    }

    public PollerBuilder<V> withWaitStrategy(WaitStrategy ... waitStrategies) {
        Preconditions.checkNotNull(waitStrategies, "waitStrategy should not be null");
        for (WaitStrategy strategy : waitStrategies) {
            Preconditions.checkNotNull(strategy, "waitStrategy should not be null");
        }
        this.waitStrategy = WaitStrategies.join(waitStrategies);
        return this;
    }

    public PollerBuilder<V> stopIfException(boolean stopIfException) {
        this.stopIfException = stopIfException;
        return this;
    }

    public PollerBuilder<V> withStopStrategy(StopStrategy stopStrategy) {
        Preconditions.checkNotNull(stopStrategy, "stopStrategy should not be null");
        Preconditions.checkState(this.stopStrategy == null, "a stopStrategy has already been set %s", (Object)this.stopStrategy);
        this.stopStrategy = stopStrategy;
        return this;
    }

    public PollerBuilder<V> withStopStrategy(StopStrategy ... stopStrategies) {
        Preconditions.checkState(this.stopStrategy == null, "a stopStrategy has already been set %s", (Object)this.stopStrategy);
        for (StopStrategy strategy : stopStrategies) {
            Preconditions.checkNotNull(strategy, "stopStrategy should not be null");
        }
        this.stopStrategy = StopStrategies.join(stopStrategies);
        return this;
    }

    public PollerBuilder<V> withExecutorService(ExecutorService executorService) {
        Preconditions.checkNotNull(executorService, "executorService should not be null");
        Preconditions.checkState(this.executorService == null, "a executorService has already been set %s", (Object)this.executorService);
        this.executorService = executorService;
        return this;
    }

    public PollerBuilder<V> polling(AttemptMaker<V> attemptMaker) {
        Preconditions.checkNotNull(attemptMaker, "attemptMake should not be null");
        Preconditions.checkState(this.attemptMaker == null, "a attemptMake has already been set %s", this.attemptMaker);
        this.attemptMaker = attemptMaker;
        return this;
    }

    public Poller<V> build() {
        Preconditions.checkNotNull(this.attemptMaker, "attemptMaker should not be null, please call polling() to add a AttemptMaker");
        return new DefaultPoller<V>(this.attemptMaker, this.buildStopStrategy(), this.waitStrategy == null ? WaitStrategies.noWait() : this.waitStrategy, this.executorService == null ? new DirectExecutorService() : this.executorService);
    }

    public static <V> PollerBuilder<V> newBuilder() {
        return new PollerBuilder<V>();
    }

    private StopStrategy buildStopStrategy() {
        if (this.stopStrategy == null) {
            this.stopStrategy = StopStrategies.neverStop();
        }
        if (this.stopIfException == null) {
            this.stopIfException = true;
        }
        return new MayStopIfExceptionStopStrategy(this.stopIfException, this.stopStrategy);
    }

    private static class MayStopIfExceptionStopStrategy
    implements StopStrategy {
        private final boolean stopIfException;
        private final StopStrategy stopStrategy;

        public MayStopIfExceptionStopStrategy(boolean stopIfException, StopStrategy stopStrategy) {
            this.stopIfException = stopIfException;
            this.stopStrategy = stopStrategy;
        }

        @Override
        public boolean shouldStop(Attempt failedAttempt) {
            if (this.stopIfException && failedAttempt.hasException()) {
                return true;
            }
            return this.stopStrategy.shouldStop(failedAttempt);
        }
    }
}

