/*
 * Decompiled with CFR 0.152.
 */
package com.eatthepath.pushy.apns;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.SocketChannel;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

class ClientChannelClassUtil {
    private static final Map<String, String> SOCKET_CHANNEL_CLASSES = new HashMap<String, String>();
    private static final Map<String, String> DATAGRAM_CHANNEL_CLASSES = new HashMap<String, String>();

    ClientChannelClassUtil() {
    }

    static Class<? extends SocketChannel> getSocketChannelClass(EventLoopGroup eventLoopGroup) {
        Objects.requireNonNull(eventLoopGroup);
        String socketChannelClassName = SOCKET_CHANNEL_CLASSES.get(eventLoopGroup.getClass().getName());
        if (socketChannelClassName == null) {
            throw new IllegalArgumentException("No socket channel class found for event loop group type: " + eventLoopGroup.getClass().getName());
        }
        try {
            return Class.forName(socketChannelClassName).asSubclass(SocketChannel.class);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }

    static Class<? extends DatagramChannel> getDatagramChannelClass(EventLoopGroup eventLoopGroup) {
        Objects.requireNonNull(eventLoopGroup);
        String datagramChannelClassName = DATAGRAM_CHANNEL_CLASSES.get(eventLoopGroup.getClass().getName());
        if (datagramChannelClassName == null) {
            throw new IllegalArgumentException("No datagram channel class found for event loop group type: " + eventLoopGroup.getClass().getName());
        }
        try {
            return Class.forName(datagramChannelClassName).asSubclass(DatagramChannel.class);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }

    static {
        SOCKET_CHANNEL_CLASSES.put("io.netty.channel.nio.NioEventLoopGroup", "io.netty.channel.socket.nio.NioSocketChannel");
        SOCKET_CHANNEL_CLASSES.put("io.netty.channel.epoll.EpollEventLoopGroup", "io.netty.channel.epoll.EpollSocketChannel");
        SOCKET_CHANNEL_CLASSES.put("io.netty.channel.kqueue.KQueueEventLoopGroup", "io.netty.channel.kqueue.KQueueSocketChannel");
        DATAGRAM_CHANNEL_CLASSES.put("io.netty.channel.nio.NioEventLoopGroup", "io.netty.channel.socket.nio.NioDatagramChannel");
        DATAGRAM_CHANNEL_CLASSES.put("io.netty.channel.epoll.EpollEventLoopGroup", "io.netty.channel.epoll.EpollDatagramChannel");
        DATAGRAM_CHANNEL_CLASSES.put("io.netty.channel.kqueue.KQueueEventLoopGroup", "io.netty.channel.kqueue.KQueueDatagramChannel");
    }
}

