/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.ECoordinate;
import com.esri.core.geometry.NumberUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Comparator;

public final class Point2D
implements Serializable {
    private static final long serialVersionUID = 1L;
    public double x;
    public double y;

    public Point2D() {
    }

    public Point2D(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public static Point2D construct(double x, double y) {
        return new Point2D(x, y);
    }

    public void setCoords(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public void setCoords(Point2D other) {
        this.x = other.x;
        this.y = other.y;
    }

    public boolean isEqual(Point2D other) {
        return this.x == other.x && this.y == other.y;
    }

    public boolean isEqual(double x_, double y_) {
        return this.x == x_ && this.y == y_;
    }

    public boolean isEqual(Point2D other, double tol) {
        return Math.abs(this.x - other.x) <= tol && Math.abs(this.y - other.y) <= tol;
    }

    public boolean equals(Point2D other) {
        return this.x == other.x && this.y == other.y;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Point2D)) {
            return false;
        }
        Point2D v = (Point2D)other;
        return this.x == v.x && this.y == v.y;
    }

    public void sub(Point2D other) {
        this.x -= other.x;
        this.y -= other.y;
    }

    public void sub(Point2D p1, Point2D p2) {
        this.x = p1.x - p2.x;
        this.y = p1.y - p2.y;
    }

    public void add(Point2D other) {
        this.x += other.x;
        this.y += other.y;
    }

    public void add(Point2D p1, Point2D p2) {
        this.x = p1.x + p2.x;
        this.y = p1.y + p2.y;
    }

    public void negate() {
        this.x = -this.x;
        this.y = -this.y;
    }

    public void negate(Point2D other) {
        this.x = -other.x;
        this.y = -other.y;
    }

    public void interpolate(Point2D other, double alpha) {
        this.x = this.x * (1.0 - alpha) + other.x * alpha;
        this.y = this.y * (1.0 - alpha) + other.y * alpha;
    }

    public void interpolate(Point2D p1, Point2D p2, double alpha) {
        this.x = p1.x * (1.0 - alpha) + p2.x * alpha;
        this.y = p1.y * (1.0 - alpha) + p2.y * alpha;
    }

    public void scaleAdd(double f, Point2D shift) {
        this.x = this.x * f + shift.x;
        this.y = this.y * f + shift.y;
    }

    public void scaleAdd(double f, Point2D other, Point2D shift) {
        this.x = other.x * f + shift.x;
        this.y = other.y * f + shift.y;
    }

    public void scale(double f, Point2D other) {
        this.x = f * other.x;
        this.y = f * other.y;
    }

    public void scale(double f) {
        this.x *= f;
        this.y *= f;
    }

    public int compare(Point2D other) {
        return this.y < other.y ? -1 : (this.y > other.y ? 1 : (this.x < other.x ? -1 : (this.x > other.x ? 1 : 0)));
    }

    public void normalize(Point2D other) {
        double len = other.length();
        if (len == 0.0) {
            this.x = 1.0;
            this.y = 0.0;
        } else {
            this.x = other.x / len;
            this.y = other.y / len;
        }
    }

    public void normalize() {
        double len = this.length();
        if (len == 0.0) {
            this.x = 1.0;
            this.y = 0.0;
        }
        this.x /= len;
        this.y /= len;
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public double sqrLength() {
        return this.x * this.x + this.y * this.y;
    }

    public static double distance(Point2D pt1, Point2D pt2) {
        return Math.sqrt(Point2D.sqrDistance(pt1, pt2));
    }

    public double dotProduct(Point2D other) {
        return this.x * other.x + this.y * other.y;
    }

    double _dotProductAbs(Point2D other) {
        return Math.abs(this.x * other.x) + Math.abs(this.y * other.y);
    }

    public double crossProduct(Point2D other) {
        return this.x * other.y - this.y * other.x;
    }

    public void rotateDirect(double Cos, double Sin) {
        double xx = this.x * Cos - this.y * Sin;
        double yy = this.x * Sin + this.y * Cos;
        this.x = xx;
        this.y = yy;
    }

    public void rotateReverse(double Cos, double Sin) {
        double xx = this.x * Cos + this.y * Sin;
        double yy = -this.x * Sin + this.y * Cos;
        this.x = xx;
        this.y = yy;
    }

    public void leftPerpendicular() {
        double xx = this.x;
        this.x = -this.y;
        this.y = xx;
    }

    public void leftPerpendicular(Point2D pt) {
        this.x = -pt.y;
        this.y = pt.x;
    }

    public void rightPerpendicular() {
        double xx = this.x;
        this.x = this.y;
        this.y = -xx;
    }

    public void rightPerpendicular(Point2D pt) {
        this.x = pt.y;
        this.y = -pt.x;
    }

    void _setNan() {
        this.x = NumberUtils.NaN();
        this.y = NumberUtils.NaN();
    }

    boolean _isNan() {
        return NumberUtils.isNaN(this.x);
    }

    final int _getQuarter() {
        if (this.x > 0.0) {
            if (this.y >= 0.0) {
                return 1;
            }
            return 4;
        }
        if (this.y > 0.0) {
            return 2;
        }
        return this.x == 0.0 ? 4 : 3;
    }

    public int getQuarter() {
        return this._getQuarter();
    }

    static final int _compareVectors(Point2D v1, Point2D v2) {
        int q1 = v1._getQuarter();
        int q2 = v2._getQuarter();
        if (q2 == q1) {
            double cross = v1.crossProduct(v2);
            return cross < 0.0 ? 1 : (cross > 0.0 ? -1 : 0);
        }
        return q1 < q2 ? -1 : 1;
    }

    public static int compareVectors(Point2D v1, Point2D v2) {
        return Point2D._compareVectors(v1, v2);
    }

    public static double sqrDistance(Point2D pt1, Point2D pt2) {
        double dx = pt1.x - pt2.x;
        double dy = pt1.y - pt2.y;
        return dx * dx + dy * dy;
    }

    public String toString() {
        return "(" + this.x + " , " + this.y + ")";
    }

    public void setNaN() {
        this.x = NumberUtils.NaN();
        this.y = NumberUtils.NaN();
    }

    public boolean isNaN() {
        return NumberUtils.isNaN(this.x) || NumberUtils.isNaN(this.y);
    }

    double _norm(int metric) {
        if (metric < 0 || this._isNan()) {
            return NumberUtils.NaN();
        }
        switch (metric) {
            case 0: {
                return Math.abs(this.x) >= Math.abs(this.y) ? Math.abs(this.x) : Math.abs(this.y);
            }
            case 1: {
                return Math.abs(this.x) + Math.abs(this.y);
            }
            case 2: {
                return Math.sqrt(this.x * this.x + this.y * this.y);
            }
        }
        return Math.pow(Math.pow(this.x, metric) + Math.pow(this.y, metric), 1.0 / (double)metric);
    }

    double offset(Point2D pt1, Point2D pt2) {
        double newDistance = Point2D.distance(pt1, pt2);
        Point2D p = Point2D.construct(this.x, this.y);
        if (newDistance == 0.0) {
            return Point2D.distance(p, pt1);
        }
        Point2D p2 = new Point2D();
        p2.setCoords(pt2);
        p2.sub(pt1);
        p.sub(pt1);
        double cross = p.crossProduct(p2);
        return cross / newDistance;
    }

    public static int orientationRobust(Point2D p, Point2D q, Point2D r) {
        ECoordinate det_ec = new ECoordinate();
        det_ec.set(q.x);
        det_ec.sub(p.x);
        ECoordinate rp_y_ec = new ECoordinate();
        rp_y_ec.set(r.y);
        rp_y_ec.sub(p.y);
        ECoordinate qp_y_ec = new ECoordinate();
        qp_y_ec.set(q.y);
        qp_y_ec.sub(p.y);
        ECoordinate rp_x_ec = new ECoordinate();
        rp_x_ec.set(r.x);
        rp_x_ec.sub(p.x);
        det_ec.mul(rp_y_ec);
        qp_y_ec.mul(rp_x_ec);
        det_ec.sub(qp_y_ec);
        if (!det_ec.isFuzzyZero()) {
            double det_ec_value = det_ec.value();
            if (det_ec_value < 0.0) {
                return -1;
            }
            if (det_ec_value > 0.0) {
                return 1;
            }
            return 0;
        }
        BigDecimal det_mp = new BigDecimal(q.x);
        BigDecimal px_mp = new BigDecimal(p.x);
        BigDecimal py_mp = new BigDecimal(p.y);
        det_mp = det_mp.subtract(px_mp);
        BigDecimal rp_y_mp = new BigDecimal(r.y);
        rp_y_mp = rp_y_mp.subtract(py_mp);
        BigDecimal qp_y_mp = new BigDecimal(q.y);
        qp_y_mp = qp_y_mp.subtract(py_mp);
        BigDecimal rp_x_mp = new BigDecimal(r.x);
        rp_x_mp = rp_x_mp.subtract(px_mp);
        det_mp = det_mp.multiply(rp_y_mp);
        qp_y_mp = qp_y_mp.multiply(rp_x_mp);
        det_mp = det_mp.subtract(qp_y_mp);
        return det_mp.signum();
    }

    public int hashCode() {
        return NumberUtils.hash(NumberUtils.hash(this.x), this.y);
    }

    static class CompareVectors
    implements Comparator<Point2D> {
        CompareVectors() {
        }

        @Override
        public int compare(Point2D v1, Point2D v2) {
            return Point2D._compareVectors(v1, v2);
        }
    }
}

