/*
 * Decompiled with CFR 0.152.
 */
package com.excilys.ebi.gatling.http.cache;

import com.excilys.ebi.gatling.core.session.Session;
import com.excilys.ebi.gatling.core.session.Session$;
import com.excilys.ebi.gatling.core.util.TimeHelper$;
import com.excilys.ebi.gatling.http.Headers$Names$;
import com.excilys.ebi.gatling.http.Headers$Values$;
import com.excilys.ebi.gatling.http.ahc.JodaTimeConverter$;
import com.excilys.ebi.gatling.http.cache.CacheHandling$;
import com.excilys.ebi.gatling.http.config.HttpProtocolConfiguration;
import com.ning.http.client.Request;
import com.ning.http.client.Response;
import com.ning.http.client.date.RFC2616Date;
import com.ning.http.client.date.RFC2616DateParser;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CacheHandling$
implements Logging {
    public static final CacheHandling$ MODULE$;
    private final String CACHE_CONTEXT_KEY;
    private final String LAST_MODIFIED_CONTEXT_KEY;
    private final String ETAG_CONTEXT_KEY;
    private final Logger grizzled$slf4j$Logging$$_logger;
    private volatile int bitmap$priv$0;

    static {
        new CacheHandling$();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final Logger grizzled$slf4j$Logging$$_logger() {
        if ((this.bitmap$priv$0 & 1) != 0) return this.grizzled$slf4j$Logging$$_logger;
        CacheHandling$ cacheHandling$ = this;
        synchronized (cacheHandling$) {
            if ((this.bitmap$priv$0 & 1) == 0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.class.grizzled$slf4j$Logging$$_logger((Logging)this);
                this.bitmap$priv$0 |= 1;
            }
            return this.grizzled$slf4j$Logging$$_logger;
        }
    }

    public Logger logger() {
        return Logging.class.logger((Logging)this);
    }

    public String loggerName() {
        return Logging.class.loggerName((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.trace((Logging)this, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.class.isDebugEnabled((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.debug((Logging)this, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.class.isErrorEnabled((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.error((Logging)this, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.class.isInfoEnabled((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.info((Logging)this, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.class.isWarnEnabled((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.warn((Logging)this, msg, t);
    }

    public String CACHE_CONTEXT_KEY() {
        return this.CACHE_CONTEXT_KEY;
    }

    public String LAST_MODIFIED_CONTEXT_KEY() {
        return this.LAST_MODIFIED_CONTEXT_KEY;
    }

    public String ETAG_CONTEXT_KEY() {
        return this.ETAG_CONTEXT_KEY;
    }

    private Set<String> getCache(Session session) {
        return (Set)session.getAttributeAsOption(this.CACHE_CONTEXT_KEY()).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Set<String> apply() {
                return Predef$.MODULE$.Set().empty();
            }
        });
    }

    public final Map<String, String> com$excilys$ebi$gatling$http$cache$CacheHandling$$getLastModifiedStore(Session session) {
        return (Map)session.getAttributeAsOption(this.LAST_MODIFIED_CONTEXT_KEY()).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Map<String, String> apply() {
                return Predef$.MODULE$.Map().empty();
            }
        });
    }

    public final Map<String, String> com$excilys$ebi$gatling$http$cache$CacheHandling$$getEtagStore(Session session) {
        return (Map)session.getAttributeAsOption(this.ETAG_CONTEXT_KEY()).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Map<String, String> apply() {
                return Predef$.MODULE$.Map().empty();
            }
        });
    }

    public boolean isFutureExpire(String timeString) {
        Option option;
        block5: {
            boolean bl;
            block4: {
                block3: {
                    String trimmedTimeString = this.removeQuote$1(timeString.trim());
                    option = Option$.MODULE$.apply((Object)new RFC2616DateParser(trimmedTimeString).parse()).map((Function1)new Serializable(){
                        public static final long serialVersionUID;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final long apply(RFC2616Date rFC2616Date) {
                            return JodaTimeConverter$.MODULE$.toTime(rFC2616Date);
                        }
                    });
                    if (!(option instanceof Some)) break block3;
                    bl = BoxesRunTime.unboxToLong((Object)((Some)option).x()) > TimeHelper$.MODULE$.nowMillis();
                    break block4;
                }
                None$ none$ = None$.MODULE$;
                Option option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block5;
                bl = false;
            }
            return bl;
        }
        throw new MatchError((Object)option);
    }

    public boolean isCached(HttpProtocolConfiguration httpProtocolConfiguration, Session session, Request request) {
        return httpProtocolConfiguration.cachingEnabled() && this.getCache(session).contains((Object)request.getUrl());
    }

    public Option<String> getLastModified(HttpProtocolConfiguration httpProtocol, Session session, String url) {
        return httpProtocol.cachingEnabled() ? this.com$excilys$ebi$gatling$http$cache$CacheHandling$$getLastModifiedStore(session).get((Object)url) : None$.MODULE$;
    }

    public Option<String> getEtag(HttpProtocolConfiguration httpProtocol, Session session, String url) {
        return httpProtocol.cachingEnabled() ? this.com$excilys$ebi$gatling$http$cache$CacheHandling$$getEtagStore(session).get((Object)url) : None$.MODULE$;
    }

    public Session cache(HttpProtocolConfiguration httpProtocolConfiguration$1, Session session, Request request, Response response$1) {
        String url$1 = request.getUrl();
        return httpProtocolConfiguration$1.cachingEnabled() ? (this.isResponseCacheable$1(httpProtocolConfiguration$1, response$1) ? this.updateCache$1(session, url$1) : this.updateEtag$1(this.updateLastModified$1(session, response$1, url$1), response$1, url$1)) : session;
    }

    private final String removeQuote$1(String s) {
        String string;
        if (s.isEmpty()) {
            string = s;
        } else {
            boolean changed = false;
            int start = 0;
            int end = s.length();
            if (s.charAt(0) == '\"') {
                ++start;
            }
            if (s.charAt(s.length() - 1) == '\"') {
                --end;
            }
            string = changed ? s.substring(start, end) : s;
        }
        return string;
    }

    private final boolean pragmaNoCache$1(Response response) {
        return BoxesRunTime.unboxToBoolean((Object)Option$.MODULE$.apply((Object)response.getHeader(Headers$Names$.MODULE$.PRAGMA())).map((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(String string) {
                return string.contains(Headers$Values$.MODULE$.NO_CACHE());
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return false;
            }
        }));
    }

    private final boolean cacheControlNoCache$1(Response response) {
        return BoxesRunTime.unboxToBoolean((Object)Option$.MODULE$.apply((Object)response.getHeader(Headers$Names$.MODULE$.CACHE_CONTROL())).map((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(String string) {
                return string.contains(Headers$Values$.MODULE$.NO_CACHE());
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return false;
            }
        }));
    }

    private final boolean expiresInFuture$1(Response response) {
        return BoxesRunTime.unboxToBoolean((Object)Option$.MODULE$.apply((Object)response.getHeader(Headers$Names$.MODULE$.EXPIRES())).map((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(String string) {
                return CacheHandling$.MODULE$.isFutureExpire(string);
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return false;
            }
        }));
    }

    private final boolean isResponseCacheable$1(HttpProtocolConfiguration httpProtocolConfiguration, Response response) {
        return httpProtocolConfiguration.cachingEnabled() && !this.pragmaNoCache$1(response) && !this.cacheControlNoCache$1(response) && this.expiresInFuture$1(response);
    }

    private final Session updateCache$1(Session session, String string) {
        Session session2;
        Set<String> cache = this.getCache(session);
        if (cache.contains((Object)string)) {
            this.logger().info((Function0)new Serializable(string){
                public static final long serialVersionUID;
                private final String url$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return new StringBuilder().append((Object)this.url$1).append((Object)" was already cached").toString();
                }
                {
                    this.url$1 = string;
                }
            });
            session2 = session;
        } else {
            this.logger().info((Function0)new Serializable(string){
                public static final long serialVersionUID;
                private final String url$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return new StringBuilder().append((Object)"Caching url ").append((Object)this.url$1).toString();
                }
                {
                    this.url$1 = string;
                }
            });
            session2 = session.setAttribute(this.CACHE_CONTEXT_KEY(), (Object)cache.$plus((Object)string));
        }
        return session2;
    }

    private final Session updateLastModified$1(Session session$1, Response response, String string) {
        return (Session)Option$.MODULE$.apply((Object)response.getHeader(Headers$Names$.MODULE$.LAST_MODIFIED())).map((Function1)new Serializable(string, session$1){
            public static final long serialVersionUID;
            public final String url$1;
            private final Session session$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Session apply(String lastModified) {
                CacheHandling$.MODULE$.logger().info((Function0)new Serializable(this){
                    public static final long serialVersionUID;
                    private final anonfun.updateLastModified.1.1 $outer;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return new StringBuilder().append((Object)"Setting LastModified for url ").append((Object)this.$outer.url$1).toString();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                Map<String, String> lastModifiedStore = CacheHandling$.MODULE$.com$excilys$ebi$gatling$http$cache$CacheHandling$$getLastModifiedStore(this.session$1);
                return this.session$1.setAttribute(CacheHandling$.MODULE$.LAST_MODIFIED_CONTEXT_KEY(), (Object)lastModifiedStore.$plus(Predef$.MODULE$.any2ArrowAssoc((Object)this.url$1).$minus$greater((Object)lastModified)));
            }
            {
                this.url$1 = string;
                this.session$1 = session;
            }
        }).getOrElse((Function0)new Serializable(session$1){
            public static final long serialVersionUID;
            private final Session session$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Session apply() {
                return this.session$1;
            }
            {
                this.session$1 = session;
            }
        });
    }

    private final Session updateEtag$1(Session session$2, Response response, String string) {
        return (Session)Option$.MODULE$.apply((Object)response.getHeader(Headers$Names$.MODULE$.ETAG())).map((Function1)new Serializable(string, session$2){
            public static final long serialVersionUID;
            public final String url$1;
            private final Session session$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Session apply(String etag) {
                CacheHandling$.MODULE$.logger().info((Function0)new Serializable(this){
                    public static final long serialVersionUID;
                    private final anonfun.updateEtag.1.1 $outer;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return new StringBuilder().append((Object)"Setting Etag for url ").append((Object)this.$outer.url$1).toString();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                Map<String, String> etagStore = CacheHandling$.MODULE$.com$excilys$ebi$gatling$http$cache$CacheHandling$$getEtagStore(this.session$2);
                return this.session$2.setAttribute(CacheHandling$.MODULE$.ETAG_CONTEXT_KEY(), (Object)etagStore.$plus(Predef$.MODULE$.any2ArrowAssoc((Object)this.url$1).$minus$greater((Object)etag)));
            }
            {
                this.url$1 = string;
                this.session$2 = session;
            }
        }).getOrElse((Function0)new Serializable(session$2){
            public static final long serialVersionUID;
            private final Session session$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Session apply() {
                return this.session$2;
            }
            {
                this.session$2 = session;
            }
        });
    }

    private CacheHandling$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.CACHE_CONTEXT_KEY = new StringBuilder().append((Object)Session$.MODULE$.GATLING_PRIVATE_ATTRIBUTE_PREFIX()).append((Object)"http.cache").toString();
        this.LAST_MODIFIED_CONTEXT_KEY = new StringBuilder().append((Object)Session$.MODULE$.GATLING_PRIVATE_ATTRIBUTE_PREFIX()).append((Object)"http.lastModified").toString();
        this.ETAG_CONTEXT_KEY = new StringBuilder().append((Object)Session$.MODULE$.GATLING_PRIVATE_ATTRIBUTE_PREFIX()).append((Object)"http.etag").toString();
    }
}

