/*
 * Decompiled with CFR 0.152.
 */
package com.excilys.ebi.gatling.mojo;

import com.excilys.ebi.gatling.ant.GatlingTask;
import com.excilys.ebi.gatling.app.CommandLineConstants;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Path;
import org.codehaus.plexus.util.StringUtils;

public class GatlingMojo
extends AbstractMojo {
    public static final String[] DEFAULT_INCLUDES = new String[]{"**/*.scala"};
    protected boolean noReports;
    protected File reportsOnly;
    protected File configDir;
    protected File simulationsFolder;
    protected List<String> includes;
    protected List<String> excludes;
    protected String simulation;
    protected File dataFolder;
    protected File requestBodiesFolder;
    protected File resultsFolder;
    protected List<String> jvmArgs;
    protected boolean failOnError = true;
    protected String outputDirectoryBaseName;
    protected MavenProject mavenProject;
    protected List<Artifact> pluginArtifacts;

    public void execute() throws MojoExecutionException {
        block2: {
            this.prepareEnvironment();
            GatlingTask gatling = this.gatling(this.gatlingArgs(), this.jvmArgs());
            try {
                gatling.execute();
            }
            catch (Exception e) {
                if (!this.failOnError) break block2;
                throw new MojoExecutionException("Gatling failed.", e);
            }
        }
    }

    protected void prepareEnvironment() {
        this.resultsFolder.mkdirs();
    }

    protected GatlingTask gatling(List<String> args, List<String> jvmArgs) throws MojoExecutionException {
        Commandline.Argument argument;
        GatlingTask gatling = new GatlingTask();
        gatling.setProject(this.getProject());
        for (String arg : args) {
            if (arg == null) continue;
            argument = gatling.createArg();
            argument.setValue(arg);
        }
        for (String jvmArg : jvmArgs) {
            if (jvmArg == null) continue;
            argument = gatling.createJvmarg();
            argument.setValue(jvmArg);
        }
        return gatling;
    }

    protected List<String> jvmArgs() {
        return this.jvmArgs != null ? this.jvmArgs : Collections.emptyList();
    }

    protected List<String> gatlingArgs() throws MojoExecutionException {
        try {
            if (this.simulation == null) {
                List<String> simulations = this.resolveSimulations(this.simulationsFolder, this.includes, this.excludes);
                if (simulations.isEmpty()) {
                    this.getLog().error((CharSequence)"No simulations to run");
                    throw new MojoFailureException("No simulations to run");
                }
                if (simulations.size() > 1) {
                    this.getLog().error((CharSequence)"More than 1 simulation to run, need to specify one");
                    throw new MojoFailureException("More than 1 simulation to run, need to specify one");
                }
                this.simulation = simulations.get(0);
            }
            ArrayList<String> args = new ArrayList<String>();
            args.addAll(Arrays.asList("-" + CommandLineConstants.CLI_DATA_FOLDER(), this.dataFolder.getCanonicalPath(), "-" + CommandLineConstants.CLI_RESULTS_FOLDER(), this.resultsFolder.getCanonicalPath(), "-" + CommandLineConstants.CLI_REQUEST_BODIES_FOLDER(), this.requestBodiesFolder.getCanonicalPath(), "-" + CommandLineConstants.CLI_SIMULATIONS_FOLDER(), this.simulationsFolder.getCanonicalPath(), "-" + CommandLineConstants.CLI_SIMULATION(), this.simulation));
            if (this.noReports) {
                args.add("-" + CommandLineConstants.CLI_NO_REPORTS());
            }
            if (this.reportsOnly != null) {
                args.addAll(Arrays.asList("-" + CommandLineConstants.CLI_REPORTS_ONLY(), this.reportsOnly.getCanonicalPath()));
            }
            if (this.outputDirectoryBaseName != null) {
                args.addAll(Arrays.asList("-" + CommandLineConstants.CLI_OUTPUT_DIRECTORY_BASE_NAME(), this.outputDirectoryBaseName));
            }
            return args;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Gatling failed.", e);
        }
    }

    protected String fileNameToClassName(String fileName) {
        String trimmedFileName = StringUtils.trim((String)fileName);
        int lastIndexOfExtensionDelim = trimmedFileName.lastIndexOf(".");
        String strippedFileName = lastIndexOfExtensionDelim > 0 ? trimmedFileName.substring(0, lastIndexOfExtensionDelim) : trimmedFileName;
        return strippedFileName.replace(File.separatorChar, '.');
    }

    protected List<String> resolveSimulations(File simulationsFolder, List<String> includes, List<String> excludes) {
        DirectoryScanner scanner = new DirectoryScanner();
        this.getLog().debug((CharSequence)("effective simulationsFolder: " + simulationsFolder.getPath()));
        scanner.setBasedir(simulationsFolder);
        if (includes != null && !includes.isEmpty()) {
            scanner.setIncludes(includes.toArray(new String[includes.size()]));
        } else {
            scanner.setIncludes(DEFAULT_INCLUDES);
        }
        if (excludes != null && !excludes.isEmpty()) {
            scanner.setExcludes(excludes.toArray(new String[excludes.size()]));
        }
        scanner.scan();
        String[] includedFiles = scanner.getIncludedFiles();
        ArrayList<String> includedClassNames = new ArrayList<String>();
        for (String includedFile : includedFiles) {
            includedClassNames.add(this.fileNameToClassName(includedFile));
        }
        this.getLog().debug((CharSequence)("resolved simulation classes: " + includedClassNames));
        return includedClassNames;
    }

    protected Project getProject() throws MojoExecutionException {
        Project project = new Project();
        project.setBaseDir(this.mavenProject.getBasedir());
        project.addBuildListener((BuildListener)new LogAdapter());
        try {
            Path classpath = new Path(project);
            this.append(classpath, this.pluginArtifacts);
            classpath.setPath(this.configDir.getPath());
            this.getLog().debug((CharSequence)("Gatling classpath : " + classpath));
            project.addReference("gatling.classpath", (Object)classpath);
            return project;
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Error resolving dependencies", (Exception)((Object)e));
        }
    }

    protected void append(Path classPath, List<?> artifacts) throws DependencyResolutionRequiredException {
        ArrayList<String> list = new ArrayList<String>();
        for (Object artifact : artifacts) {
            String path;
            if (artifact instanceof Artifact) {
                Artifact a = (Artifact)artifact;
                File file = a.getFile();
                if (file == null) {
                    throw new DependencyResolutionRequiredException(a);
                }
                path = file.getPath();
            } else {
                path = artifact.toString();
            }
            list.add(path);
        }
        Path p = new Path(classPath.getProject());
        p.setPath(StringUtils.join(list.iterator(), (String)File.pathSeparator));
        classPath.append(p);
    }

    public class LogAdapter
    implements BuildListener {
        public void buildStarted(BuildEvent event) {
            this.log(event);
        }

        public void buildFinished(BuildEvent event) {
            this.log(event);
        }

        public void targetStarted(BuildEvent event) {
            this.log(event);
        }

        public void targetFinished(BuildEvent event) {
            this.log(event);
        }

        public void taskStarted(BuildEvent event) {
            this.log(event);
        }

        public void taskFinished(BuildEvent event) {
            this.log(event);
        }

        public void messageLogged(BuildEvent event) {
            this.log(event);
        }

        private void log(BuildEvent event) {
            int priority = event.getPriority();
            Log log = GatlingMojo.this.getLog();
            String message = event.getMessage();
            switch (priority) {
                case 0: {
                    log.error((CharSequence)message);
                    break;
                }
                case 1: {
                    log.warn((CharSequence)message);
                    break;
                }
                case 2: {
                    log.info((CharSequence)message);
                    break;
                }
                case 3: {
                    log.debug((CharSequence)message);
                    break;
                }
                case 4: {
                    log.debug((CharSequence)message);
                    break;
                }
                default: {
                    log.info((CharSequence)message);
                }
            }
        }
    }
}

