/*
 * Decompiled with CFR 0.152.
 */
package com.excilys.ebi.gatling.mojo;

import com.excilys.ebi.gatling.app.CommandLineConstants;
import com.excilys.ebi.gatling.app.Gatling;
import com.excilys.ebi.gatling.mojo.GatlingJavaMainCallerByFork;
import com.excilys.ebi.gatling.mojo.GatlingJavaMainCallerInProcess;
import com.excilys.ebi.gatling.mojo.GatlingSimulationChecksFailedException;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.exec.ExecuteException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.StringUtils;
import scala_maven_executions.MainHelper;
import scala_maven_executions.MainWithArgsInFile;

public class GatlingMojo
extends AbstractMojo {
    public static final String[] DEFAULT_INCLUDES = new String[]{"**/*.scala"};
    public static final String GATLING_MAIN_CLASS = "com.excilys.ebi.gatling.app.Gatling";
    public static final String[] JVM_ARGS = new String[]{"-server", "-XX:+UseThreadPriorities", "-XX:ThreadPriorityPolicy=42", "-Xms512M", "-Xmx512M", "-Xmn100M", "-Xss2M", "-XX:+HeapDumpOnOutOfMemoryError", "-XX:+AggressiveOpts", "-XX:+OptimizeStringConcat", "-XX:+UseFastAccessorMethods", "-XX:+UseParNewGC", "-XX:+UseConcMarkSweepGC", "-XX:+CMSParallelRemarkEnabled", "-XX:+CMSClassUnloadingEnabled", "-XX:CMSInitiatingOccupancyFraction=75", "-XX:+UseCMSInitiatingOccupancyOnly", "-XX:SurvivorRatio=8", "-XX:MaxTenuringThreshold=1"};
    private boolean noReports;
    private String reportsOnly;
    private File configDir;
    private File simulationsFolder;
    private List<String> includes;
    private List<String> excludes;
    private String simulationClass;
    private File dataFolder;
    private File requestBodiesFolder;
    private File resultsFolder;
    private List<String> jvmArgs;
    private boolean fork;
    private boolean failOnError;
    private String outputDirectoryBaseName;
    private boolean propagateSystemProperties;
    private boolean skip;
    private MavenProject mavenProject;
    private MavenSession session;
    private ToolchainManager toolchainManager;

    public void execute() throws MojoExecutionException {
        this.resultsFolder.mkdirs();
        try {
            this.executeGatling(this.jvmArgs().toArray(new String[0]), this.gatlingArgs().toArray(new String[0]));
        }
        catch (Exception e) {
            if (this.failOnError) {
                throw new MojoExecutionException("Gatling failed.", e);
            }
            this.getLog().warn((CharSequence)"There was some errors while running your simulation, but failOnError set to false won't fail your build.");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void executeGatling(String[] jvmArgs, String[] gatlingArgs) throws Exception {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping gatling-maven-plugin");
            return;
        }
        String testClasspath = this.buildTestClasspath();
        if (!this.fork) {
            GatlingJavaMainCallerInProcess caller = new GatlingJavaMainCallerInProcess(this, GATLING_MAIN_CLASS, testClasspath, gatlingArgs);
            int returnCode = caller.run();
            if (returnCode != Gatling.SIMULATION_CHECK_FAILED()) return;
            throw new GatlingSimulationChecksFailedException();
        }
        Toolchain toolchain = this.toolchainManager.getToolchainFromBuildContext("jdk", this.session);
        GatlingJavaMainCallerByFork caller = new GatlingJavaMainCallerByFork(this, GATLING_MAIN_CLASS, testClasspath, jvmArgs, gatlingArgs, false, toolchain, this.propagateSystemProperties);
        try {
            caller.run(false);
            return;
        }
        catch (ExecuteException e) {
            if (e.getExitValue() != Gatling.SIMULATION_CHECK_FAILED()) return;
            throw new GatlingSimulationChecksFailedException(e);
        }
    }

    private String buildTestClasspath() throws Exception {
        List testClasspathElements = this.mavenProject.getTestClasspathElements();
        testClasspathElements.add(this.configDir.getPath());
        testClasspathElements.add(MainHelper.locateJar(GatlingMojo.class));
        testClasspathElements.add(MainHelper.locateJar(MainWithArgsInFile.class));
        return MainHelper.toMultiPath((List)testClasspathElements);
    }

    private List<String> jvmArgs() {
        ArrayList<String> jvmArguments = this.jvmArgs != null ? this.jvmArgs : new ArrayList<String>();
        jvmArguments.addAll(Arrays.asList(JVM_ARGS));
        return jvmArguments;
    }

    private List<String> gatlingArgs() throws Exception {
        if (this.simulationClass == null) {
            List<String> simulations = this.resolveSimulations(this.simulationsFolder, this.includes, this.excludes);
            if (simulations.isEmpty()) {
                this.getLog().error((CharSequence)"No simulations to run");
                throw new MojoFailureException("No simulations to run");
            }
            if (simulations.size() > 1) {
                this.getLog().error((CharSequence)"More than 1 simulation to run, need to specify one");
                throw new MojoFailureException("More than 1 simulation to run, need to specify one");
            }
            this.simulationClass = simulations.get(0);
        }
        ArrayList<String> args = new ArrayList<String>();
        args.addAll(Arrays.asList("-" + CommandLineConstants.CLI_DATA_FOLDER(), this.dataFolder.getCanonicalPath(), "-" + CommandLineConstants.CLI_RESULTS_FOLDER(), this.resultsFolder.getCanonicalPath(), "-" + CommandLineConstants.CLI_REQUEST_BODIES_FOLDER(), this.requestBodiesFolder.getCanonicalPath(), "-" + CommandLineConstants.CLI_SIMULATIONS_FOLDER(), this.simulationsFolder.getCanonicalPath(), "-" + CommandLineConstants.CLI_SIMULATION(), this.simulationClass));
        if (this.noReports) {
            args.add("-" + CommandLineConstants.CLI_NO_REPORTS());
        }
        if (this.reportsOnly != null) {
            args.addAll(Arrays.asList("-" + CommandLineConstants.CLI_REPORTS_ONLY(), this.reportsOnly));
        }
        if (this.outputDirectoryBaseName != null) {
            args.addAll(Arrays.asList("-" + CommandLineConstants.CLI_OUTPUT_DIRECTORY_BASE_NAME(), this.outputDirectoryBaseName));
        }
        return args;
    }

    public static String fileNameToClassName(String fileName) {
        String trimmedFileName = StringUtils.trim((String)fileName);
        int lastIndexOfExtensionDelim = trimmedFileName.lastIndexOf(".");
        String strippedFileName = lastIndexOfExtensionDelim > 0 ? trimmedFileName.substring(0, lastIndexOfExtensionDelim) : trimmedFileName;
        return strippedFileName.replace(File.separatorChar, '.');
    }

    private List<String> resolveSimulations(File simulationsFolder, List<String> includes, List<String> excludes) {
        DirectoryScanner scanner = new DirectoryScanner();
        this.getLog().debug((CharSequence)("effective simulationsFolder: " + simulationsFolder.getPath()));
        scanner.setBasedir(simulationsFolder);
        if (includes != null && !includes.isEmpty()) {
            scanner.setIncludes(includes.toArray(new String[includes.size()]));
        } else {
            scanner.setIncludes(DEFAULT_INCLUDES);
        }
        if (excludes != null && !excludes.isEmpty()) {
            scanner.setExcludes(excludes.toArray(new String[excludes.size()]));
        }
        scanner.scan();
        String[] includedFiles = scanner.getIncludedFiles();
        ArrayList<String> includedClassNames = new ArrayList<String>();
        for (String includedFile : includedFiles) {
            includedClassNames.add(GatlingMojo.fileNameToClassName(includedFile));
        }
        this.getLog().debug((CharSequence)("resolved simulation classes: " + includedClassNames));
        return includedClassNames;
    }
}

