/*
 * Decompiled with CFR 0.152.
 */
package com.ezylang.evalex.bigmath.utils;

import ch.obermuhlner.math.big.BigDecimalMath;
import java.math.BigDecimal;
import java.math.MathContext;

public class BigDecimalMathExtension {
    private BigDecimalMathExtension() {
    }

    public static BigDecimal round(BigDecimal value, MathContext mathContext) {
        if (value.abs().compareTo(BigDecimal.ONE.scaleByPowerOfTen(-mathContext.getPrecision())) < 0) {
            return BigDecimal.ZERO;
        }
        return value.round(mathContext);
    }

    public static BigDecimal toRadians(BigDecimal degrees, MathContext mathContext) {
        MathContext mc = new MathContext(mathContext.getPrecision() + 4, mathContext.getRoundingMode());
        BigDecimal factor = BigDecimalMath.pi((MathContext)mc).divide(BigDecimal.valueOf(180L), mc);
        return BigDecimalMathExtension.round(degrees.multiply(factor, mc), mathContext);
    }

    public static BigDecimal toDegrees(BigDecimal radians, MathContext mathContext) {
        MathContext mc = new MathContext(mathContext.getPrecision() + 4, mathContext.getRoundingMode());
        BigDecimal factor = BigDecimal.valueOf(180L).divide(BigDecimalMath.pi((MathContext)mc), mc);
        return BigDecimalMathExtension.round(radians.multiply(factor, mc), mathContext);
    }
}

