/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.avro.deser;

import com.fasterxml.jackson.dataformat.avro.deser.ArrayReader;
import com.fasterxml.jackson.dataformat.avro.deser.AvroFieldDefaulters;
import com.fasterxml.jackson.dataformat.avro.deser.AvroFieldReader;
import com.fasterxml.jackson.dataformat.avro.deser.AvroStructureReader;
import com.fasterxml.jackson.dataformat.avro.deser.MapReader;
import com.fasterxml.jackson.dataformat.avro.deser.RecordReader;
import com.fasterxml.jackson.dataformat.avro.deser.ScalarDecoder;
import com.fasterxml.jackson.dataformat.avro.deser.ScalarDecoderWrapper;
import com.fasterxml.jackson.dataformat.avro.deser.UnionReader;
import com.fasterxml.jackson.dataformat.avro.schema.AvroSchemaHelper;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.TreeMap;
import org.apache.avro.Schema;

public abstract class AvroReaderFactory {
    protected static final ScalarDecoder READER_BOOLEAN = new ScalarDecoder.BooleanDecoder();
    protected static final ScalarDecoder READER_BYTES = new ScalarDecoder.BytesDecoder();
    protected static final ScalarDecoder READER_DOUBLE = new ScalarDecoder.DoubleReader();
    protected static final ScalarDecoder READER_FLOAT = new ScalarDecoder.FloatReader();
    protected static final ScalarDecoder READER_INT = new ScalarDecoder.IntReader();
    protected static final ScalarDecoder READER_LONG = new ScalarDecoder.LongReader();
    protected static final ScalarDecoder READER_NULL = new ScalarDecoder.NullReader();
    protected static final ScalarDecoder READER_STRING = new ScalarDecoder.StringReader();
    protected final TreeMap<String, AvroStructureReader> _knownReaders = new TreeMap();

    public static AvroStructureReader createFor(Schema schema) {
        return new NonResolving().createReader(schema);
    }

    public static AvroStructureReader createFor(Schema writerSchema, Schema readerSchema) {
        return new Resolving().createReader(writerSchema, readerSchema);
    }

    public ScalarDecoder createScalarValueDecoder(Schema type) {
        switch (type.getType()) {
            case BOOLEAN: {
                return READER_BOOLEAN;
            }
            case BYTES: {
                return READER_BYTES;
            }
            case DOUBLE: {
                return READER_DOUBLE;
            }
            case ENUM: {
                return new ScalarDecoder.EnumDecoder(AvroSchemaHelper.getFullName(type), type.getEnumSymbols());
            }
            case FIXED: {
                return new ScalarDecoder.FixedDecoder(type.getFixedSize(), AvroSchemaHelper.getFullName(type));
            }
            case FLOAT: {
                return READER_FLOAT;
            }
            case INT: {
                if (AvroSchemaHelper.getTypeId(type) != null) {
                    return new ScalarDecoder.IntReader(AvroSchemaHelper.getTypeId(type));
                }
                return READER_INT;
            }
            case LONG: {
                return READER_LONG;
            }
            case NULL: {
                return READER_NULL;
            }
            case STRING: {
                if (AvroSchemaHelper.getTypeId(type) != null) {
                    return new ScalarDecoder.StringReader(AvroSchemaHelper.getTypeId(type));
                }
                return READER_STRING;
            }
            case UNION: {
                List types = type.getTypes();
                ScalarDecoder[] readers = new ScalarDecoder[types.size()];
                int i = 0;
                for (Schema schema : types) {
                    ScalarDecoder reader = this.createScalarValueDecoder(schema);
                    if (reader == null) {
                        return null;
                    }
                    readers[i++] = reader;
                }
                return new ScalarDecoder.ScalarUnionDecoder(readers);
            }
            case ARRAY: 
            case MAP: 
            case RECORD: {
                return null;
            }
        }
        throw new IllegalStateException("Unrecognized Avro Schema type: " + type.getType());
    }

    public AvroStructureReader createReader(Schema schema) {
        AvroStructureReader reader = this._knownReaders.get(AvroSchemaHelper.getFullName(schema));
        if (reader != null) {
            return reader;
        }
        switch (schema.getType()) {
            case ARRAY: {
                return this.createArrayReader(schema);
            }
            case MAP: {
                return this.createMapReader(schema);
            }
            case RECORD: {
                return this.createRecordReader(schema);
            }
            case UNION: {
                return this.createUnionReader(schema);
            }
        }
        return new ScalarDecoderWrapper(this.createScalarValueDecoder(schema));
    }

    protected AvroStructureReader createArrayReader(Schema schema) {
        Schema elementType = schema.getElementType();
        ScalarDecoder scalar = this.createScalarValueDecoder(elementType);
        String typeId = AvroSchemaHelper.getTypeId(schema);
        String elementTypeId = schema.getProp("java-element-class");
        if (elementTypeId == null) {
            elementTypeId = AvroSchemaHelper.getTypeId(elementType);
        }
        if (scalar != null) {
            if (EnumSet.class.getName().equals(typeId)) {
                typeId = typeId + "<" + elementTypeId + ">";
            }
            return ArrayReader.construct(scalar, typeId, elementTypeId);
        }
        return ArrayReader.construct(this.createReader(elementType), typeId, elementTypeId);
    }

    protected AvroStructureReader createMapReader(Schema schema) {
        Schema elementType = schema.getValueType();
        ScalarDecoder dec = this.createScalarValueDecoder(elementType);
        String typeId = AvroSchemaHelper.getTypeId(schema);
        String keyTypeId = schema.getProp("java-key-class");
        if (EnumMap.class.getName().equals(typeId)) {
            typeId = typeId + "<" + keyTypeId + "," + Object.class.getName() + ">";
        }
        if (dec != null) {
            String valueTypeId = AvroSchemaHelper.getTypeId(elementType);
            return MapReader.construct(dec, typeId, keyTypeId, valueTypeId);
        }
        return MapReader.construct(this.createReader(elementType), typeId, keyTypeId);
    }

    protected AvroStructureReader createRecordReader(Schema schema) {
        List fields = schema.getFields();
        AvroFieldReader[] fieldReaders = new AvroFieldReader[fields.size()];
        RecordReader.Std reader = new RecordReader.Std(fieldReaders, AvroSchemaHelper.getTypeId(schema));
        this._knownReaders.put(AvroSchemaHelper.getFullName(schema), reader);
        int i = 0;
        for (Schema.Field field : fields) {
            fieldReaders[i++] = this.createFieldReader(field);
        }
        return reader;
    }

    protected AvroStructureReader createUnionReader(Schema schema) {
        List types = schema.getTypes();
        AvroStructureReader[] typeReaders = new AvroStructureReader[types.size()];
        int i = 0;
        for (Schema type : types) {
            typeReaders[i++] = this.createReader(type);
        }
        return new UnionReader(typeReaders);
    }

    protected AvroFieldReader createFieldReader(Schema.Field field) {
        String name = field.name();
        Schema type = field.schema();
        ScalarDecoder scalar = this.createScalarValueDecoder(type);
        if (scalar != null) {
            return scalar.asFieldReader(name, false);
        }
        return AvroFieldReader.construct(name, this.createReader(type));
    }

    private static class Resolving
    extends AvroReaderFactory {
        protected Resolving() {
        }

        public AvroStructureReader createReader(Schema writerSchema, Schema readerSchema) {
            AvroStructureReader reader = (AvroStructureReader)((Object)this._knownReaders.get(AvroSchemaHelper.getFullName(readerSchema)));
            if (reader != null) {
                return reader;
            }
            switch (writerSchema.getType()) {
                case ARRAY: {
                    return this.createArrayReader(writerSchema, readerSchema);
                }
                case MAP: {
                    return this.createMapReader(writerSchema, readerSchema);
                }
                case RECORD: {
                    return this.createRecordReader(writerSchema, readerSchema);
                }
                case UNION: {
                    return this.createUnionReader(writerSchema, readerSchema);
                }
            }
            return new ScalarDecoderWrapper(this.createScalarValueDecoder(writerSchema));
        }

        protected AvroStructureReader createArrayReader(Schema writerSchema, Schema readerSchema) {
            readerSchema = this._verifyMatchingStructure(readerSchema, writerSchema);
            Schema writerElementType = writerSchema.getElementType();
            ScalarDecoder scalar = this.createScalarValueDecoder(writerElementType);
            String typeId = AvroSchemaHelper.getTypeId(readerSchema);
            String elementTypeId = readerSchema.getProp("java-element-class");
            if (scalar != null) {
                return ArrayReader.construct(scalar, typeId, elementTypeId);
            }
            return ArrayReader.construct(this.createReader(writerElementType, readerSchema.getElementType()), typeId, elementTypeId);
        }

        protected AvroStructureReader createMapReader(Schema writerSchema, Schema readerSchema) {
            readerSchema = this._verifyMatchingStructure(readerSchema, writerSchema);
            Schema writerElementType = writerSchema.getValueType();
            ScalarDecoder dec = this.createScalarValueDecoder(writerElementType);
            String typeId = AvroSchemaHelper.getTypeId(readerSchema);
            String keyTypeId = readerSchema.getProp("java-key-class");
            if (dec != null) {
                String valueTypeId = readerSchema.getValueType().getProp("java-class");
                return MapReader.construct(dec, typeId, keyTypeId, valueTypeId);
            }
            return MapReader.construct(this.createReader(writerElementType, readerSchema.getValueType()), typeId, keyTypeId);
        }

        protected AvroStructureReader createRecordReader(Schema writerSchema, Schema readerSchema) {
            readerSchema = this._verifyMatchingStructure(readerSchema, writerSchema);
            List writerFields = writerSchema.getFields();
            HashMap<String, Schema.Field> readerFields = new HashMap<String, Schema.Field>();
            ArrayList<Schema.Field> defaultFields = new ArrayList<Schema.Field>();
            HashSet<String> writerNames = new HashSet<String>();
            for (Schema.Field f : writerFields) {
                writerNames.add(f.name());
            }
            for (Schema.Field f : readerSchema.getFields()) {
                String name = f.name();
                if (writerNames.contains(name)) {
                    readerFields.put(name, f);
                    continue;
                }
                defaultFields.add(f);
            }
            AvroFieldReader[] fieldReaders = new AvroFieldReader[writerFields.size() + defaultFields.size()];
            RecordReader.Resolving reader = new RecordReader.Resolving(fieldReaders, AvroSchemaHelper.getTypeId(readerSchema));
            this._knownReaders.put(AvroSchemaHelper.getFullName(readerSchema), reader);
            int i = 0;
            for (Schema.Field writerField : writerFields) {
                Schema.Field readerField = (Schema.Field)readerFields.get(writerField.name());
                fieldReaders[i++] = readerField == null ? this.createFieldSkipper(writerField.name(), writerField.schema()) : this.createFieldReader(readerField.name(), writerField.schema(), readerField.schema());
            }
            if (!defaultFields.isEmpty()) {
                for (Schema.Field defaultField : defaultFields) {
                    AvroFieldReader fr = AvroFieldDefaulters.createDefaulter(defaultField.name(), AvroSchemaHelper.objectToJsonNode(defaultField.defaultVal()));
                    if (fr == null) {
                        throw new IllegalArgumentException("Unsupported default type: " + defaultField.schema().getType());
                    }
                    fieldReaders[i++] = fr;
                }
            }
            return reader;
        }

        protected AvroStructureReader createUnionReader(Schema writerSchema, Schema readerSchema) {
            List types = writerSchema.getTypes();
            AvroStructureReader[] typeReaders = new AvroStructureReader[types.size()];
            int i = 0;
            for (Schema type : types) {
                typeReaders[i++] = this.createReader(type);
            }
            return new UnionReader(typeReaders);
        }

        protected AvroFieldReader createFieldReader(String name, Schema writerSchema, Schema readerSchema) {
            ScalarDecoder scalar = this.createScalarValueDecoder(writerSchema);
            if (scalar != null) {
                return scalar.asFieldReader(name, false);
            }
            return AvroFieldReader.construct(name, this.createReader(writerSchema, readerSchema));
        }

        protected AvroFieldReader createFieldSkipper(String name, Schema writerSchema) {
            ScalarDecoder scalar = this.createScalarValueDecoder(writerSchema);
            if (scalar != null) {
                return scalar.asFieldReader(name, true);
            }
            return AvroFieldReader.constructSkipper(name, this.createReader(writerSchema));
        }

        private Schema _verifyMatchingStructure(Schema readerSchema, Schema writerSchema) {
            Schema.Type expectedType = writerSchema.getType();
            Schema.Type actualType = readerSchema.getType();
            if (actualType == expectedType) {
                return readerSchema;
            }
            if (actualType == Schema.Type.UNION) {
                for (Schema sch : readerSchema.getTypes()) {
                    if (sch.getType() != expectedType) continue;
                    return sch;
                }
                throw new IllegalStateException(String.format("Mismatch between types: expected %s (name '%s'), encountered %s of %d types without match", expectedType, writerSchema.getName(), actualType, readerSchema.getTypes().size()));
            }
            throw new IllegalStateException(String.format("Mismatch between types: expected %s (name '%s'), encountered %s", expectedType, writerSchema.getName(), actualType));
        }
    }

    private static class NonResolving
    extends AvroReaderFactory {
        protected NonResolving() {
        }
    }
}

