/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.avro;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedConstructor;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.dataformat.avro.AvroTypeResolverBuilder;
import com.fasterxml.jackson.dataformat.avro.PackageVersion;
import com.fasterxml.jackson.dataformat.avro.apacheimpl.CustomEncodingDeserializer;
import com.fasterxml.jackson.dataformat.avro.schema.AvroSchemaHelper;
import com.fasterxml.jackson.dataformat.avro.ser.CustomEncodingSerializer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.avro.reflect.AvroAlias;
import org.apache.avro.reflect.AvroDefault;
import org.apache.avro.reflect.AvroEncode;
import org.apache.avro.reflect.AvroIgnore;
import org.apache.avro.reflect.AvroName;
import org.apache.avro.reflect.CustomEncoding;
import org.apache.avro.reflect.Nullable;
import org.apache.avro.reflect.Stringable;
import org.apache.avro.reflect.Union;

public class AvroAnnotationIntrospector
extends AnnotationIntrospector {
    private static final long serialVersionUID = 1L;

    public Version version() {
        return PackageVersion.VERSION;
    }

    public boolean hasIgnoreMarker(AnnotatedMember m) {
        return this._findAnnotation((Annotated)m, AvroIgnore.class) != null;
    }

    public PropertyName findNameForSerialization(Annotated a) {
        return this._findName(a);
    }

    public PropertyName findNameForDeserialization(Annotated a) {
        return this._findName(a);
    }

    public Object findDeserializer(Annotated am) {
        AvroEncode ann = (AvroEncode)this._findAnnotation(am, AvroEncode.class);
        if (ann != null) {
            return new CustomEncodingDeserializer((CustomEncoding)ClassUtil.createInstance((Class)ann.using(), (boolean)true));
        }
        return null;
    }

    public String findPropertyDefaultValue(Annotated m) {
        AvroDefault ann = (AvroDefault)this._findAnnotation(m, AvroDefault.class);
        return ann == null ? null : ann.value();
    }

    public List<PropertyName> findPropertyAliases(Annotated m) {
        AvroAlias ann = (AvroAlias)this._findAnnotation(m, AvroAlias.class);
        if (ann == null) {
            return null;
        }
        return Collections.singletonList(PropertyName.construct((String)ann.alias()));
    }

    protected PropertyName _findName(Annotated a) {
        AvroName ann = (AvroName)this._findAnnotation(a, AvroName.class);
        return ann == null ? null : PropertyName.construct((String)ann.value());
    }

    public Boolean hasRequiredMarker(AnnotatedMember m) {
        if (this._hasAnnotation((Annotated)m, Nullable.class)) {
            return Boolean.FALSE;
        }
        return null;
    }

    public JsonCreator.Mode findCreatorAnnotation(MapperConfig<?> config, Annotated a) {
        AnnotatedConstructor constructor;
        Class declClass;
        if (a instanceof AnnotatedConstructor && (declClass = (constructor = (AnnotatedConstructor)a).getDeclaringClass()).getAnnotation(Stringable.class) != null && constructor.getParameterCount() == 1 && String.class.equals((Object)constructor.getRawParameterType(0))) {
            return JsonCreator.Mode.DELEGATING;
        }
        return null;
    }

    public Object findSerializer(Annotated a) {
        if (a.hasAnnotation(Stringable.class)) {
            return ToStringSerializer.class;
        }
        AvroEncode ann = (AvroEncode)this._findAnnotation(a, AvroEncode.class);
        if (ann != null) {
            return new CustomEncodingSerializer((CustomEncoding)ClassUtil.createInstance((Class)ann.using(), (boolean)true));
        }
        return null;
    }

    public List<NamedType> findSubtypes(Annotated a) {
        Class<?>[] types = this._getUnionTypes(a);
        if (types == null) {
            return null;
        }
        ArrayList<NamedType> names = new ArrayList<NamedType>(types.length);
        for (Class<?> subtype : types) {
            names.add(new NamedType(subtype, AvroSchemaHelper.getTypeId(subtype)));
        }
        return names;
    }

    public TypeResolverBuilder<?> findTypeResolver(MapperConfig<?> config, AnnotatedClass ac, JavaType baseType) {
        return this._findTypeResolver(config, (Annotated)ac, baseType);
    }

    public TypeResolverBuilder<?> findPropertyTypeResolver(MapperConfig<?> config, AnnotatedMember am, JavaType baseType) {
        return this._findTypeResolver(config, (Annotated)am, baseType);
    }

    public TypeResolverBuilder<?> findPropertyContentTypeResolver(MapperConfig<?> config, AnnotatedMember am, JavaType containerType) {
        return this._findTypeResolver(config, (Annotated)am, containerType);
    }

    protected TypeResolverBuilder<?> _findTypeResolver(MapperConfig<?> config, Annotated ann, JavaType baseType) {
        if (baseType.isJavaLangObject() || this._getUnionTypes(ann) != null) {
            AvroTypeResolverBuilder resolver = new AvroTypeResolverBuilder();
            JsonTypeInfo typeInfo = (JsonTypeInfo)ann.getAnnotation(JsonTypeInfo.class);
            if (typeInfo != null && typeInfo.defaultImpl() != JsonTypeInfo.class) {
                resolver = resolver.defaultImpl(typeInfo.defaultImpl());
            }
            return resolver;
        }
        return null;
    }

    protected Class<?>[] _getUnionTypes(Annotated a) {
        Class[] c;
        Union ann = (Union)this._findAnnotation(a, Union.class);
        if (ann != null && (c = ann.value()).length > 0) {
            return c;
        }
        return null;
    }
}

