/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.avro.schema;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonStringFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonValueFormat;
import com.fasterxml.jackson.dataformat.avro.schema.AvroSchemaHelper;
import com.fasterxml.jackson.dataformat.avro.schema.SchemaBuilder;
import java.util.Set;
import org.apache.avro.Schema;

public class StringVisitor
extends JsonStringFormatVisitor.Base
implements SchemaBuilder {
    protected final SerializerProvider _provider;
    protected final JavaType _type;

    public StringVisitor(SerializerProvider provider, JavaType type) {
        this._type = type;
        this._provider = provider;
    }

    public void format(JsonValueFormat format) {
    }

    public void enumTypes(Set<String> enums) {
    }

    @Override
    public Schema builtAvroSchema() {
        if (this._type.hasRawClass(Character.TYPE) || this._type.hasRawClass(Character.class)) {
            return AvroSchemaHelper.numericAvroSchema(JsonParser.NumberType.INT, this._type);
        }
        BeanDescription bean = this._provider.getConfig().introspectClassAnnotations(this._type);
        Schema schema = Schema.create((Schema.Type)Schema.Type.STRING);
        if (AvroSchemaHelper.isStringable(bean.getClassInfo()) && !this._type.hasRawClass(String.class)) {
            schema.addProp("java-class", AvroSchemaHelper.getTypeId(this._type));
        }
        return schema;
    }
}

