/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.protobuf;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.dataformat.protobuf.PackageVersion;
import com.fasterxml.jackson.dataformat.protobuf.ProtobufFactory;
import com.fasterxml.jackson.dataformat.protobuf.schema.DescriptorLoader;
import com.fasterxml.jackson.dataformat.protobuf.schema.FileDescriptorSet;
import com.fasterxml.jackson.dataformat.protobuf.schema.ProtobufSchema;
import com.fasterxml.jackson.dataformat.protobuf.schema.ProtobufSchemaLoader;
import com.fasterxml.jackson.dataformat.protobuf.schemagen.ProtobufSchemaGenerator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class ProtobufMapper
extends ObjectMapper {
    private static final long serialVersionUID = 1L;
    protected ProtobufSchemaLoader _schemaLoader = ProtobufSchemaLoader.std;
    protected DescriptorLoader _descriptorLoader;

    public ProtobufMapper() {
        this(new ProtobufFactory());
    }

    public ProtobufMapper(ProtobufFactory f) {
        super((JsonFactory)f);
    }

    protected ProtobufMapper(ProtobufMapper src) {
        super((ObjectMapper)src);
    }

    public ProtobufMapper copy() {
        this._checkInvalidCopy(ProtobufMapper.class);
        return new ProtobufMapper(this);
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public ProtobufFactory getFactory() {
        return (ProtobufFactory)this._jsonFactory;
    }

    public ProtobufSchemaLoader schemaLoader() {
        return this._schemaLoader;
    }

    public void setSchemaLoader(ProtobufSchemaLoader l) {
        this._schemaLoader = l;
    }

    public ProtobufSchema generateSchemaFor(JavaType type) throws JsonMappingException {
        ProtobufSchemaGenerator gen = new ProtobufSchemaGenerator();
        this.acceptJsonFormatVisitor(type, (JsonFormatVisitorWrapper)gen);
        return gen.getGeneratedSchema();
    }

    public ProtobufSchema generateSchemaFor(Class<?> type) throws JsonMappingException {
        ProtobufSchemaGenerator gen = new ProtobufSchemaGenerator();
        this.acceptJsonFormatVisitor(type, (JsonFormatVisitorWrapper)gen);
        return gen.getGeneratedSchema();
    }

    public FileDescriptorSet loadDescriptorSet(URL src) throws IOException {
        return this.descriptorLoader().load(src);
    }

    public FileDescriptorSet loadDescriptorSet(File src) throws IOException {
        return this.descriptorLoader().load(src);
    }

    public FileDescriptorSet loadDescriptorSet(InputStream src) throws IOException {
        return this.descriptorLoader().load(src);
    }

    public synchronized DescriptorLoader descriptorLoader() throws IOException {
        DescriptorLoader l = this._descriptorLoader;
        if (l == null) {
            this._descriptorLoader = l = DescriptorLoader.construct(this);
        }
        return l;
    }
}

