/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.jaxrs.xml;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.jaxrs.base.ProviderBase;
import com.fasterxml.jackson.jaxrs.cfg.Annotations;
import com.fasterxml.jackson.jaxrs.cfg.MapperConfiguratorBase;
import com.fasterxml.jackson.jaxrs.xml.PackageVersion;
import com.fasterxml.jackson.jaxrs.xml.XMLEndpointConfig;
import com.fasterxml.jackson.jaxrs.xml.XMLMapperConfigurator;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.lang.annotation.Annotation;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.Providers;

@Provider
@Consumes(value={"*/*"})
@Produces(value={"application/xml", "text/xml", "*/*"})
public class JacksonXMLProvider
extends ProviderBase<JacksonXMLProvider, XmlMapper, XMLEndpointConfig, XMLMapperConfigurator> {
    public static final Annotations[] BASIC_ANNOTATIONS = new Annotations[]{Annotations.JACKSON};
    @Context
    protected Providers _providers;

    public JacksonXMLProvider() {
        this((XmlMapper)null, BASIC_ANNOTATIONS);
    }

    public JacksonXMLProvider(Annotations ... annotationsToUse) {
        this((XmlMapper)null, annotationsToUse);
    }

    public JacksonXMLProvider(XmlMapper mapper) {
        this(mapper, BASIC_ANNOTATIONS);
    }

    public JacksonXMLProvider(XmlMapper mapper, Annotations[] annotationsToUse) {
        super((MapperConfiguratorBase)new XMLMapperConfigurator(mapper, annotationsToUse));
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    protected XMLEndpointConfig _configForReading(ObjectReader reader, Annotation[] annotations) {
        return XMLEndpointConfig.forReading(reader, annotations);
    }

    protected XMLEndpointConfig _configForWriting(ObjectWriter writer, Annotation[] annotations) {
        return XMLEndpointConfig.forWriting(writer, annotations);
    }

    protected boolean hasMatchingMediaType(MediaType mediaType) {
        if (mediaType != null) {
            String subtype = mediaType.getSubtype();
            return "xml".equalsIgnoreCase(subtype) || subtype.endsWith("+xml");
        }
        return true;
    }

    public XmlMapper _locateMapperViaProvider(Class<?> type, MediaType mediaType) {
        XmlMapper m = ((XMLMapperConfigurator)this._mapperConfig).getConfiguredMapper();
        if (m == null && (m = (XmlMapper)this._locateMapperViaProvider(type, mediaType, XmlMapper.class, this._providers)) == null) {
            m = ((XMLMapperConfigurator)this._mapperConfig).getDefaultMapper();
        }
        return m;
    }

    protected JsonParser _createParser(ObjectReader reader, InputStream rawStream) throws IOException {
        PushbackInputStream wrappedStream = new PushbackInputStream(rawStream);
        int firstByte = wrappedStream.read();
        if (firstByte == -1) {
            return null;
        }
        wrappedStream.unread(firstByte);
        return reader.getFactory().createParser((InputStream)wrappedStream);
    }
}

