/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.jr.annotationsupport;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.jr.annotationsupport.AnnotationBasedIntrospector;
import com.fasterxml.jackson.jr.ob.api.ReaderWriterModifier;
import com.fasterxml.jackson.jr.ob.api.ValueWriter;
import com.fasterxml.jackson.jr.ob.impl.JSONReader;
import com.fasterxml.jackson.jr.ob.impl.JSONWriter;
import com.fasterxml.jackson.jr.ob.impl.POJODefinition;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

public class AnnotationBasedValueRWModifier
extends ReaderWriterModifier {
    protected static final int SER_ENUM_ID = 23;
    protected final JsonAutoDetect.Value _visibility;

    public AnnotationBasedValueRWModifier(JsonAutoDetect.Value value) {
        this._visibility = value;
    }

    public POJODefinition pojoDefinitionForDeserialization(JSONReader jSONReader, Class<?> clazz) {
        return AnnotationBasedIntrospector.pojoDefinitionForDeserialization(jSONReader, clazz, this._visibility);
    }

    public POJODefinition pojoDefinitionForSerialization(JSONWriter jSONWriter, Class<?> clazz) {
        return AnnotationBasedIntrospector.pojoDefinitionForSerialization(jSONWriter, clazz, this._visibility);
    }

    public ValueWriter overrideStandardValueWriter(JSONWriter jSONWriter, Class<?> clazz, int n) {
        if (n == 23) {
            return new EnumWriter(clazz);
        }
        return null;
    }

    private static class EnumWriter
    implements ValueWriter {
        private final Class<?> _valueType;
        private final Map<String, String> enumMap;

        public EnumWriter(Class<?> clazz) {
            Field[] fieldArray;
            this._valueType = clazz;
            this.enumMap = new HashMap<String, String>();
            for (Field field : fieldArray = clazz.getDeclaredFields()) {
                if (field.isAnnotationPresent(JsonProperty.class)) {
                    this.enumMap.put(field.getName(), field.getAnnotation(JsonProperty.class).value());
                    continue;
                }
                this.enumMap.put(field.getName(), field.getName());
            }
        }

        public void writeValue(JSONWriter jSONWriter, JsonGenerator jsonGenerator, Object object) throws IOException {
            jSONWriter.writeValue((Object)this.enumMap.get(((Enum)object).name()));
        }

        public Class<?> valueType() {
            return this._valueType;
        }
    }
}

