/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.jr.stree;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.jr.stree.JacksonJrsTreeCodec;
import com.fasterxml.jackson.jr.stree.JrsValue;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class JrsNumber
extends JrsValue.Scalar {
    private static final Map<Class<? extends Number>, JsonParser.NumberType> NUMBER_TYPES;
    private final Number _value;
    private final JsonParser.NumberType _numberType;

    public JrsNumber(Number number) {
        this._value = number;
        this._numberType = NUMBER_TYPES.get(number.getClass());
        if (this._numberType == null) {
            throw new IllegalArgumentException("Unsupported Number type: " + number.getClass().getName());
        }
    }

    @Override
    public boolean isNumber() {
        return true;
    }

    public Number getValue() {
        return this._value;
    }

    public JsonToken asToken() {
        switch (this.numberType()) {
            case BIG_DECIMAL: 
            case DOUBLE: 
            case FLOAT: {
                return JsonToken.VALUE_NUMBER_FLOAT;
            }
        }
        return JsonToken.VALUE_NUMBER_INT;
    }

    @Override
    public String asText() {
        return String.valueOf(this._value);
    }

    @Override
    public JsonParser.NumberType numberType() {
        return this._numberType;
    }

    public BigInteger asBigInteger() throws IOException {
        if (this._value instanceof BigInteger) {
            return (BigInteger)this._value;
        }
        if (this._value instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)this._value;
            return bigDecimal.toBigInteger();
        }
        return BigInteger.valueOf(this._value.longValue());
    }

    public BigDecimal asBigDecimal() throws IOException {
        if (this._value instanceof BigDecimal) {
            return (BigDecimal)this._value;
        }
        if (this._value instanceof BigInteger) {
            return new BigDecimal((BigInteger)this._value);
        }
        if (this._value instanceof Double || this._value instanceof Float) {
            return BigDecimal.valueOf(this._value.doubleValue());
        }
        return BigDecimal.valueOf(this._value.longValue());
    }

    @Override
    protected void write(JsonGenerator jsonGenerator, JacksonJrsTreeCodec jacksonJrsTreeCodec) throws IOException {
        switch (this.numberType()) {
            case INT: {
                jsonGenerator.writeNumber(this._value.intValue());
                break;
            }
            case LONG: {
                jsonGenerator.writeNumber(this._value.longValue());
                break;
            }
            case BIG_INTEGER: {
                jsonGenerator.writeNumber((BigInteger)this._value);
                break;
            }
            case FLOAT: {
                jsonGenerator.writeNumber(this._value.floatValue());
                break;
            }
            case BIG_DECIMAL: {
                jsonGenerator.writeNumber((BigDecimal)this._value);
                break;
            }
            default: {
                jsonGenerator.writeNumber(this._value.doubleValue());
            }
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        JrsNumber jrsNumber = (JrsNumber)object;
        if (this._value != null ? !this._value.equals(jrsNumber._value) : jrsNumber._value != null) {
            return false;
        }
        return this._numberType == jrsNumber._numberType;
    }

    public int hashCode() {
        int n = this._value != null ? this._value.hashCode() : 0;
        n = 31 * n + (this._numberType != null ? this._numberType.hashCode() : 0);
        return n;
    }

    static {
        HashMap<Class, JsonParser.NumberType> hashMap = new HashMap<Class, JsonParser.NumberType>();
        hashMap.put(Byte.class, JsonParser.NumberType.INT);
        hashMap.put(Short.class, JsonParser.NumberType.INT);
        hashMap.put(Integer.class, JsonParser.NumberType.INT);
        hashMap.put(Long.class, JsonParser.NumberType.LONG);
        hashMap.put(BigInteger.class, JsonParser.NumberType.BIG_INTEGER);
        hashMap.put(Float.class, JsonParser.NumberType.FLOAT);
        hashMap.put(Double.class, JsonParser.NumberType.DOUBLE);
        hashMap.put(BigDecimal.class, JsonParser.NumberType.BIG_DECIMAL);
        NUMBER_TYPES = Collections.unmodifiableMap(hashMap);
    }
}

