/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.uuid;

import java.io.Serializable;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.security.SecureRandom;
import java.util.Enumeration;
import java.util.Random;

public class EthernetAddress
implements Serializable,
Cloneable,
Comparable<EthernetAddress> {
    private static final long serialVersionUID = 1L;
    private static final char[] HEX_CHARS = "0123456789abcdefABCDEF".toCharArray();
    protected static Random _rnd;
    protected final long _address;
    private volatile String _asString;

    public EthernetAddress(String addrStr) throws NumberFormatException {
        int len = addrStr.length();
        long addr = 0L;
        int i = 0;
        for (int j = 0; j < 6; ++j) {
            int value;
            if (i >= len) {
                if (j == 5) {
                    addr <<= 8;
                    break;
                }
                throw new NumberFormatException("Incomplete ethernet address (missing one or more digits");
            }
            char c = addrStr.charAt(i);
            ++i;
            if (c == ':') {
                value = 0;
            } else {
                if (c >= '0' && c <= '9') {
                    value = c - 48;
                } else if (c >= 'a' && c <= 'f') {
                    value = c - 97 + 10;
                } else if (c >= 'A' && c <= 'F') {
                    value = c - 65 + 10;
                } else {
                    throw new NumberFormatException("Non-hex character '" + c + "'");
                }
                if (i < len) {
                    c = addrStr.charAt(i);
                    ++i;
                    if (c != ':') {
                        value <<= 4;
                        if (c >= '0' && c <= '9') {
                            value |= c - 48;
                        } else if (c >= 'a' && c <= 'f') {
                            value |= c - 97 + 10;
                        } else if (c >= 'A' && c <= 'F') {
                            value |= c - 65 + 10;
                        } else {
                            throw new NumberFormatException("Non-hex character '" + c + "'");
                        }
                    }
                }
            }
            addr = addr << 8 | (long)value;
            if (c == ':') continue;
            if (i < len) {
                if (addrStr.charAt(i) != ':') {
                    throw new NumberFormatException("Expected ':', got ('" + addrStr.charAt(i) + "')");
                }
                ++i;
                continue;
            }
            if (j >= 5) continue;
            throw new NumberFormatException("Incomplete ethernet address (missing one or more digits");
        }
        this._address = addr;
    }

    public EthernetAddress(byte[] addr) throws NumberFormatException {
        if (addr.length != 6) {
            throw new NumberFormatException("Ethernet address has to consist of 6 bytes");
        }
        long l = addr[0] & 0xFF;
        for (int i = 1; i < 6; ++i) {
            l = l << 8 | (long)(addr[i] & 0xFF);
        }
        this._address = l;
    }

    public EthernetAddress(long addr) {
        this._address = addr;
    }

    public Object clone() {
        return new EthernetAddress(this._address);
    }

    public static EthernetAddress valueOf(byte[] addr) throws NumberFormatException {
        return new EthernetAddress(addr);
    }

    public static EthernetAddress valueOf(int[] addr) throws NumberFormatException {
        byte[] bAddr = new byte[addr.length];
        for (int i = 0; i < addr.length; ++i) {
            bAddr[i] = (byte)addr[i];
        }
        return new EthernetAddress(bAddr);
    }

    public static EthernetAddress valueOf(String addrStr) throws NumberFormatException {
        return new EthernetAddress(addrStr);
    }

    public static EthernetAddress valueOf(long addr) {
        return new EthernetAddress(addr);
    }

    public static EthernetAddress fromInterface() {
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                byte[] data;
                NetworkInterface nint = en.nextElement();
                if (nint.isLoopback() || (data = nint.getHardwareAddress()) == null || data.length != 6) continue;
                return new EthernetAddress(data);
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return null;
    }

    public static EthernetAddress constructMulticastAddress() {
        return EthernetAddress.constructMulticastAddress(EthernetAddress._randomNumberGenerator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EthernetAddress constructMulticastAddress(Random rnd) {
        byte[] dummy = new byte[6];
        Random random = rnd;
        synchronized (random) {
            rnd.nextBytes(dummy);
        }
        dummy[0] = (byte)(dummy[0] | 1);
        return new EthernetAddress(dummy);
    }

    public byte[] asByteArray() {
        byte[] result = new byte[6];
        this.toByteArray(result);
        return result;
    }

    public byte[] toByteArray() {
        return this.asByteArray();
    }

    public void toByteArray(byte[] array) {
        if (array.length < 6) {
            throw new IllegalArgumentException("Too small array, need to have space for 6 bytes");
        }
        this.toByteArray(array, 0);
    }

    public void toByteArray(byte[] array, int pos) {
        if (pos < 0 || pos + 6 > array.length) {
            throw new IllegalArgumentException("Illegal offset (" + pos + "), need room for 6 bytes");
        }
        int i = (int)(this._address >> 32);
        array[pos++] = (byte)(i >> 8);
        array[pos++] = (byte)i;
        i = (int)this._address;
        array[pos++] = (byte)(i >> 24);
        array[pos++] = (byte)(i >> 16);
        array[pos++] = (byte)(i >> 8);
        array[pos] = (byte)i;
    }

    public long toLong() {
        return this._address;
    }

    public boolean isMulticastAddress() {
        return ((int)(this._address >> 40) & 1) != 0;
    }

    public boolean isLocallyAdministeredAddress() {
        return ((int)(this._address >> 40) & 2) != 0;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        return ((EthernetAddress)o)._address == this._address;
    }

    public int hashCode() {
        return (int)this._address ^ (int)(this._address >>> 32);
    }

    @Override
    public int compareTo(EthernetAddress other) {
        long l = this._address - other._address;
        if (l < 0L) {
            return -1;
        }
        return l == 0L ? 0 : 1;
    }

    public String toString() {
        String str = this._asString;
        if (str != null) {
            return str;
        }
        StringBuilder b = new StringBuilder(17);
        int i1 = (int)(this._address >> 32);
        int i2 = (int)this._address;
        this._appendHex(b, i1 >> 8);
        b.append(':');
        this._appendHex(b, i1);
        b.append(':');
        this._appendHex(b, i2 >> 24);
        b.append(':');
        this._appendHex(b, i2 >> 16);
        b.append(':');
        this._appendHex(b, i2 >> 8);
        b.append(':');
        this._appendHex(b, i2);
        this._asString = str = b.toString();
        return str;
    }

    protected static synchronized Random _randomNumberGenerator() {
        if (_rnd == null) {
            _rnd = new SecureRandom();
        }
        return _rnd;
    }

    private final void _appendHex(StringBuilder sb, int hex) {
        sb.append(HEX_CHARS[hex >> 4 & 0xF]);
        sb.append(HEX_CHARS[hex & 0xF]);
    }
}

