/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.actions;

import com.galenframework.actions.GalenAction;
import com.galenframework.actions.GalenActionDumpArguments;
import com.galenframework.api.GalenPageDump;
import com.galenframework.browser.Browser;
import com.galenframework.browser.SeleniumBrowserFactory;
import com.galenframework.parser.SyntaxException;
import java.io.IOException;
import java.io.PrintStream;

public class GalenActionDump
extends GalenAction {
    private final GalenActionDumpArguments dumpArguments;

    public GalenActionDump(String[] arguments, PrintStream outStream, PrintStream errStream) {
        super(arguments, outStream, errStream);
        this.dumpArguments = GalenActionDumpArguments.parse(arguments);
    }

    @Override
    public void execute() throws IOException {
        this.loadConfigIfNeeded(this.getDumpArguments().getConfig());
        SeleniumBrowserFactory browserFactory = new SeleniumBrowserFactory();
        Browser browser = browserFactory.openBrowser();
        try {
            if (this.dumpArguments.getUrl() == null || this.dumpArguments.getUrl().isEmpty()) {
                throw new SyntaxException("--url parameter is not defined");
            }
            if (this.dumpArguments.getPaths() == null || this.dumpArguments.getPaths().size() == 0) {
                throw new SyntaxException("You should specify a spec file with which you want to make a page dump");
            }
            if (this.dumpArguments.getExport() == null || this.dumpArguments.getExport().isEmpty()) {
                throw new SyntaxException("--export parameter is not defined");
            }
            if (this.dumpArguments.getScreenSize() != null) {
                browser.changeWindowSize(this.dumpArguments.getScreenSize());
            }
            browser.load(this.dumpArguments.getUrl());
            new GalenPageDump(this.dumpArguments.getUrl()).setMaxWidth(this.dumpArguments.getMaxWidth()).setMaxHeight(this.dumpArguments.getMaxHeight()).dumpPage(browser, this.dumpArguments.getPaths().get(0), this.dumpArguments.getExport());
            this.outStream.println("Done!");
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            browser.quit();
        }
    }

    public GalenActionDumpArguments getDumpArguments() {
        return this.dumpArguments;
    }
}

