/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.actions;

import com.galenframework.actions.GalenAction;
import com.galenframework.actions.GalenActionGenerateArguments;
import com.galenframework.generator.PageSpecGenerationResult;
import com.galenframework.generator.SpecGenerator;
import com.galenframework.generator.builders.SpecGeneratorOptions;
import com.galenframework.utils.GalenUtils;
import java.io.File;
import java.io.PrintStream;
import org.apache.commons.io.FileUtils;

public class GalenActionGenerate
extends GalenAction {
    private final GalenActionGenerateArguments generateArguments;

    public GalenActionGenerate(String[] arguments, PrintStream outStream, PrintStream errStream) {
        super(arguments, outStream, errStream);
        this.generateArguments = GalenActionGenerateArguments.parse(arguments);
    }

    @Override
    public void execute() throws Exception {
        SpecGenerator specGenerator = new SpecGenerator();
        SpecGeneratorOptions specGeneratorOptions = new SpecGeneratorOptions();
        specGeneratorOptions.setUseGalenExtras(this.generateArguments.isUseGalenExtras());
        PageSpecGenerationResult result = specGenerator.generate(GalenUtils.findFileOrResourceAsStream(this.generateArguments.getPath()), specGeneratorOptions);
        String text = SpecGenerator.generatePageSpec(result, specGeneratorOptions);
        File outputFile = new File(this.generateArguments.getExport());
        outputFile.createNewFile();
        FileUtils.writeStringToFile((File)outputFile, (String)text);
    }

    public GalenActionGenerateArguments getGenerateArguments() {
        return this.generateArguments;
    }
}

