/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.actions;

import com.galenframework.actions.ArgumentsUtils;
import com.galenframework.suite.actions.mutation.MutationOptions;
import com.galenframework.utils.GalenUtils;
import java.awt.Dimension;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class GalenActionMutateArguments {
    private List<String> paths;
    private List<String> includedTags;
    private List<String> excludedTags;
    private String url;
    private Dimension screenSize;
    private String javascript;
    private String config;
    private String htmlReport;
    private String jsonReport;
    private String testngReport;
    private String junitReport;
    private MutationOptions mutationOptions = new MutationOptions();

    public static GalenActionMutateArguments parse(String[] args) {
        CommandLine cmd;
        args = ArgumentsUtils.processSystemProperties(args);
        Options options = new Options();
        options.addOption("i", "include", true, "Tags for sections that should be included in test run");
        options.addOption("e", "exclude", true, "Tags for sections that should be excluded from test run");
        options.addOption("u", "url", true, "Initial test url");
        options.addOption("s", "size", true, "Browser window size");
        options.addOption("o", "offset", true, "Offset for each mutation (default 5)");
        options.addOption("h", "htmlreport", true, "Path for html output report");
        options.addOption("j", "jsonreport", true, "Path for json report");
        options.addOption("g", "testngreport", true, "Path for testng xml report");
        options.addOption("x", "junitreport", true, "Path for junit xml report");
        options.addOption("J", "javascript", true, "JavaScript code that should be executed before checking layout");
        options.addOption("c", "config", true, "Path to config");
        PosixParser parser = new PosixParser();
        try {
            cmd = parser.parse(options, args);
        }
        catch (MissingArgumentException e) {
            throw new IllegalArgumentException("Missing value for " + e.getOption().getLongOpt(), e);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        GalenActionMutateArguments arguments = new GalenActionMutateArguments();
        arguments.setUrl(cmd.getOptionValue("u"));
        arguments.setScreenSize(GalenUtils.readSize(cmd.getOptionValue("s")));
        arguments.setJavascript(cmd.getOptionValue("J"));
        arguments.setHtmlReport(cmd.getOptionValue("h"));
        arguments.setJsonReport(cmd.getOptionValue("j"));
        arguments.setTestngReport(cmd.getOptionValue("g"));
        arguments.setJunitReport(cmd.getOptionValue("x"));
        arguments.setIncludedTags(ArgumentsUtils.convertTags(cmd.getOptionValue("i")));
        arguments.setExcludedTags(ArgumentsUtils.convertTags(cmd.getOptionValue("e")));
        arguments.setPaths(Arrays.asList(cmd.getArgs()));
        arguments.setConfig(cmd.getOptionValue("c"));
        arguments.getMutationOptions().setPositionOffset(Integer.parseInt(cmd.getOptionValue("o", "5")));
        if (arguments.getPaths().isEmpty()) {
            throw new IllegalArgumentException("Missing spec files");
        }
        return arguments;
    }

    public List<String> getPaths() {
        return this.paths;
    }

    public GalenActionMutateArguments setPaths(List<String> paths) {
        this.paths = paths;
        return this;
    }

    public List<String> getIncludedTags() {
        return this.includedTags;
    }

    public GalenActionMutateArguments setIncludedTags(List<String> includedTags) {
        this.includedTags = includedTags;
        return this;
    }

    public List<String> getExcludedTags() {
        return this.excludedTags;
    }

    public GalenActionMutateArguments setExcludedTags(List<String> excludedTags) {
        this.excludedTags = excludedTags;
        return this;
    }

    public String getUrl() {
        return this.url;
    }

    public GalenActionMutateArguments setUrl(String url) {
        this.url = url;
        return this;
    }

    public Dimension getScreenSize() {
        return this.screenSize;
    }

    public GalenActionMutateArguments setScreenSize(Dimension screenSize) {
        this.screenSize = screenSize;
        return this;
    }

    public String getConfig() {
        return this.config;
    }

    public GalenActionMutateArguments setConfig(String config) {
        this.config = config;
        return this;
    }

    public String getJavascript() {
        return this.javascript;
    }

    public GalenActionMutateArguments setJavascript(String javascript) {
        this.javascript = javascript;
        return this;
    }

    public GalenActionMutateArguments setHtmlReport(String htmlReport) {
        this.htmlReport = htmlReport;
        return this;
    }

    public String getHtmlReport() {
        return this.htmlReport;
    }

    public GalenActionMutateArguments setJsonReport(String jsonReport) {
        this.jsonReport = jsonReport;
        return this;
    }

    public String getJsonReport() {
        return this.jsonReport;
    }

    public GalenActionMutateArguments setTestngReport(String testngReport) {
        this.testngReport = testngReport;
        return this;
    }

    public String getTestngReport() {
        return this.testngReport;
    }

    public GalenActionMutateArguments setJunitReport(String junitReport) {
        this.junitReport = junitReport;
        return this;
    }

    public String getJunitReport() {
        return this.junitReport;
    }

    public MutationOptions getMutationOptions() {
        return this.mutationOptions;
    }

    public GalenActionMutateArguments setMutationOptions(MutationOptions mutationOptions) {
        this.mutationOptions = mutationOptions;
        return this;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("paths", this.paths).append("includedTags", this.includedTags).append("excludedTags", this.excludedTags).append("url", (Object)this.url).append("screenSize", (Object)this.screenSize).append("javascript", (Object)this.javascript).append("config", (Object)this.config).append("htmlReport", (Object)this.htmlReport).append("jsonReport", (Object)this.jsonReport).append("testngReport", (Object)this.testngReport).append("junitReport", (Object)this.junitReport).append("mutationOptions", (Object)this.mutationOptions).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GalenActionMutateArguments that = (GalenActionMutateArguments)o;
        return new EqualsBuilder().append(this.paths, that.paths).append(this.includedTags, that.includedTags).append(this.excludedTags, that.excludedTags).append((Object)this.url, (Object)that.url).append((Object)this.screenSize, (Object)that.screenSize).append((Object)this.javascript, (Object)that.javascript).append((Object)this.config, (Object)that.config).append((Object)this.htmlReport, (Object)that.htmlReport).append((Object)this.jsonReport, (Object)that.jsonReport).append((Object)this.testngReport, (Object)that.testngReport).append((Object)this.junitReport, (Object)that.junitReport).append((Object)this.mutationOptions, (Object)that.mutationOptions).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.paths).append(this.includedTags).append(this.excludedTags).append((Object)this.url).append((Object)this.screenSize).append((Object)this.javascript).append((Object)this.config).append((Object)this.htmlReport).append((Object)this.jsonReport).append((Object)this.testngReport).append((Object)this.junitReport).append((Object)this.mutationOptions).toHashCode();
    }
}

