/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.actions;

import com.galenframework.actions.ArgumentsUtils;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class GalenActionTestArguments {
    private List<String> paths;
    private Boolean recursive = false;
    private List<String> includedTags = new LinkedList<String>();
    private List<String> excludedTags = new LinkedList<String>();
    private String htmlReport;
    private String testngReport;
    private String junitReport;
    private int parallelThreads = 0;
    private String filter;
    private String jsonReport;
    private List<String> groups;
    private List<String> excludedGroups;
    private String config;

    public static GalenActionTestArguments parse(String[] args) {
        CommandLine cmd;
        args = ArgumentsUtils.processSystemProperties(args);
        Options options = new Options();
        options.addOption("i", "include", true, "Tags for sections that should be included in test run");
        options.addOption("e", "exclude", true, "Tags for sections that should be excluded from test run");
        options.addOption("h", "htmlreport", true, "Path for html output report");
        options.addOption("j", "jsonreport", true, "Path for json report");
        options.addOption("g", "testngreport", true, "Path for testng xml report");
        options.addOption("x", "junitreport", true, "Path for junit xml report");
        options.addOption("r", "recursive", false, "Flag for recursive tests scan");
        options.addOption("p", "parallel-tests", true, "Amount of tests to be run in parallel");
        options.addOption("P", "parallel-suites", true, "Amount of tests to be run in parallel");
        options.addOption("f", "filter", true, "Test filter");
        options.addOption("G", "groups", true, "Test groups");
        options.addOption("Q", "excluded-groups", true, "Excluded test groups");
        options.addOption("c", "config", true, "Path to galen config file");
        PosixParser parser = new PosixParser();
        try {
            cmd = parser.parse(options, args);
        }
        catch (MissingArgumentException e) {
            throw new IllegalArgumentException("Missing value for " + e.getOption().getLongOpt(), e);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        GalenActionTestArguments arguments = new GalenActionTestArguments();
        arguments.setIncludedTags(ArgumentsUtils.convertTags(cmd.getOptionValue("i", "")));
        arguments.setExcludedTags(ArgumentsUtils.convertTags(cmd.getOptionValue("e", "")));
        arguments.setTestngReport(cmd.getOptionValue("g"));
        arguments.setJunitReport(cmd.getOptionValue("x"));
        arguments.setRecursive(cmd.hasOption("r"));
        arguments.setHtmlReport(cmd.getOptionValue("h"));
        if (cmd.hasOption("p")) {
            arguments.setParallelThreads(Integer.parseInt(cmd.getOptionValue("p", "0")));
        } else {
            arguments.setParallelThreads(Integer.parseInt(cmd.getOptionValue("P", "0")));
        }
        arguments.setFilter(cmd.getOptionValue("f"));
        arguments.setJsonReport(cmd.getOptionValue("j"));
        arguments.setGroups(ArgumentsUtils.convertTags(cmd.getOptionValue("G")));
        arguments.setExcludedGroups(ArgumentsUtils.convertTags(cmd.getOptionValue("Q")));
        arguments.setPaths(Arrays.asList(cmd.getArgs()));
        arguments.setConfig(cmd.getOptionValue("c"));
        if (arguments.getPaths().isEmpty()) {
            throw new IllegalArgumentException("Missing test files");
        }
        return arguments;
    }

    public List<String> getPaths() {
        return this.paths;
    }

    public GalenActionTestArguments setPaths(List<String> paths) {
        this.paths = paths;
        return this;
    }

    public Boolean getRecursive() {
        return this.recursive;
    }

    public GalenActionTestArguments setRecursive(Boolean recursive) {
        this.recursive = recursive;
        return this;
    }

    public List<String> getExcludedGroups() {
        return this.excludedGroups;
    }

    public GalenActionTestArguments setExcludedGroups(List<String> excludedGroups) {
        this.excludedGroups = excludedGroups;
        return this;
    }

    public List<String> getGroups() {
        return this.groups;
    }

    public GalenActionTestArguments setGroups(List<String> groups) {
        this.groups = groups;
        return this;
    }

    public String getJsonReport() {
        return this.jsonReport;
    }

    public GalenActionTestArguments setJsonReport(String jsonReport) {
        this.jsonReport = jsonReport;
        return this;
    }

    public String getFilter() {
        return this.filter;
    }

    public GalenActionTestArguments setFilter(String filter) {
        this.filter = filter;
        return this;
    }

    public int getParallelThreads() {
        return this.parallelThreads;
    }

    public GalenActionTestArguments setParallelThreads(int parallelThreads) {
        this.parallelThreads = parallelThreads;
        return this;
    }

    public String getJunitReport() {
        return this.junitReport;
    }

    public String getTestngReport() {
        return this.testngReport;
    }

    public GalenActionTestArguments setJunitReport(String junitReport) {
        this.junitReport = junitReport;
        return this;
    }

    public GalenActionTestArguments setTestngReport(String testngReport) {
        this.testngReport = testngReport;
        return this;
    }

    public String getHtmlReport() {
        return this.htmlReport;
    }

    public GalenActionTestArguments setHtmlReport(String htmlReport) {
        this.htmlReport = htmlReport;
        return this;
    }

    public List<String> getExcludedTags() {
        return this.excludedTags;
    }

    public GalenActionTestArguments setExcludedTags(List<String> excludedTags) {
        this.excludedTags = excludedTags;
        return this;
    }

    public List<String> getIncludedTags() {
        return this.includedTags;
    }

    public GalenActionTestArguments setIncludedTags(List<String> includedTags) {
        this.includedTags = includedTags;
        return this;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.paths).append((Object)this.recursive).append(this.includedTags).append(this.excludedTags).append((Object)this.htmlReport).append((Object)this.testngReport).append((Object)this.junitReport).append(this.parallelThreads).append((Object)this.filter).append((Object)this.jsonReport).append(this.groups).append(this.excludedGroups).append((Object)this.config).toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof GalenActionTestArguments)) {
            return false;
        }
        GalenActionTestArguments rhs = (GalenActionTestArguments)obj;
        return new EqualsBuilder().append(this.paths, rhs.paths).append((Object)this.recursive, (Object)rhs.recursive).append(this.includedTags, rhs.includedTags).append(this.excludedTags, rhs.excludedTags).append((Object)this.htmlReport, (Object)rhs.htmlReport).append((Object)this.testngReport, (Object)rhs.testngReport).append((Object)this.junitReport, (Object)rhs.junitReport).append(this.parallelThreads, rhs.parallelThreads).append((Object)this.filter, (Object)rhs.filter).append((Object)this.jsonReport, (Object)rhs.jsonReport).append(this.groups, rhs.groups).append(this.excludedGroups, rhs.excludedGroups).append((Object)this.config, (Object)rhs.config).isEquals();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("paths", this.paths).append("recursive", (Object)this.recursive).append("includedTags", this.includedTags).append("excludedTags", this.excludedTags).append("htmlReport", (Object)this.htmlReport).append("testngReport", (Object)this.testngReport).append("junitReport", (Object)this.junitReport).append("parallelThreads", this.parallelThreads).append("filter", (Object)this.filter).append("jsonReport", (Object)this.jsonReport).append("groups", this.groups).append("excludedGroups", this.excludedGroups).append("config", (Object)this.config).toString();
    }

    public GalenActionTestArguments setConfig(String config) {
        this.config = config;
        return this;
    }

    public String getConfig() {
        return this.config;
    }
}

