/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.api.mutation;

import com.galenframework.api.Galen;
import com.galenframework.browser.Browser;
import com.galenframework.browser.mutation.MutationExecBrowser;
import com.galenframework.browser.mutation.MutationRecordBrowser;
import com.galenframework.page.PageElement;
import com.galenframework.reports.model.LayoutReport;
import com.galenframework.speclang2.pagespec.PageSpecReader;
import com.galenframework.speclang2.pagespec.SectionFilter;
import com.galenframework.specs.page.Locator;
import com.galenframework.specs.page.PageSpec;
import com.galenframework.suite.actions.mutation.AreaMutation;
import com.galenframework.suite.actions.mutation.MutationOptions;
import com.galenframework.suite.actions.mutation.MutationReport;
import com.galenframework.suite.actions.mutation.PageElementMutation;
import com.galenframework.suite.actions.mutation.PageMutation;
import com.galenframework.validation.ValidationListener;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class GalenMutate {
    private static final Map<String, Object> NO_JS_VARIABLES = Collections.emptyMap();
    private static final ValidationListener NO_LISTENER = null;
    private static final Map<String, Locator> NO_OBJECTS = null;

    public static MutationReport checkAllMutations(Browser browser, String specPath, List<String> includedTags, List<String> excludedTags, MutationOptions mutationOptions, Properties properties, ValidationListener validationListener) throws IOException {
        File screenshotFile;
        MutationRecordBrowser mutationRecordBrowser = new MutationRecordBrowser(browser);
        SectionFilter sectionFilter = new SectionFilter(includedTags, excludedTags);
        PageSpec pageSpec = GalenMutate.parseSpec(specPath, browser, sectionFilter, properties);
        LayoutReport initialLayoutReport = Galen.checkLayout(mutationRecordBrowser, pageSpec, sectionFilter, screenshotFile = browser.getPage().getScreenshotFile(), validationListener);
        MutationReport mutationReport = initialLayoutReport.errors() > 0 ? GalenMutate.createCrashedMutationReport("Cannot perform mutation testing. There are errors in initial layout validation report") : GalenMutate.testAllMutations(mutationRecordBrowser.getRecordedElements(), browser, pageSpec, sectionFilter, mutationOptions, screenshotFile);
        mutationReport.setInitialLayoutReport(initialLayoutReport);
        return mutationReport;
    }

    private static MutationReport createCrashedMutationReport(String error) {
        MutationReport mutationReport = new MutationReport();
        mutationReport.setError(error);
        return mutationReport;
    }

    private static PageSpec parseSpec(String specPath, Browser browser, SectionFilter sectionFilter, Properties properties) throws IOException {
        return new PageSpecReader().read(specPath, browser.getPage(), sectionFilter, properties, NO_JS_VARIABLES, NO_OBJECTS);
    }

    private static MutationReport testAllMutations(Map<String, PageElement> recordedElements, Browser browser, PageSpec pageSpec, SectionFilter sectionFilter, MutationOptions mutationOptions, File screenshotFile) {
        List<PageMutation> mutations = recordedElements.entrySet().stream().filter(GalenMutate.nonViewport()).map(e -> GalenMutate.generateMutationsFor((String)e.getKey(), mutationOptions)).flatMap(Collection::stream).collect(Collectors.toList());
        MutationExecBrowser mutationExecBrowser = new MutationExecBrowser(browser, recordedElements);
        MutationReport mutationReport = new MutationReport();
        mutations.forEach(mutation -> GalenMutate.testMutation(mutation, mutationReport, mutationExecBrowser, pageSpec, sectionFilter, screenshotFile));
        return mutationReport;
    }

    private static void testMutation(PageMutation pageMutation, MutationReport mutationReport, MutationExecBrowser mutationExecBrowser, PageSpec pageSpec, SectionFilter sectionFilter, File screenshotFile) {
        mutationExecBrowser.setActiveMutations(GalenMutate.toMutationMap(pageMutation.getPageElementMutations()));
        try {
            LayoutReport layoutReport = Galen.checkLayout(mutationExecBrowser, pageSpec, sectionFilter, screenshotFile, NO_LISTENER);
            if (layoutReport.errors() == 0) {
                mutationReport.reportFailedMutation(pageMutation);
            } else {
                mutationReport.reportSuccessMutation(pageMutation);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Mutation crashed: " + pageMutation.getName(), ex);
        }
    }

    private static Map<String, AreaMutation> toMutationMap(List<PageElementMutation> pageElementMutations) {
        HashMap<String, AreaMutation> map = new HashMap<String, AreaMutation>();
        pageElementMutations.forEach(pem -> map.put(pem.getElementName(), pem.getAreaMutation()));
        return map;
    }

    private static List<PageMutation> generateMutationsFor(String name, MutationOptions mutationOptions) {
        return AreaMutation.generateStandardMutations(mutationOptions).stream().map(areaMutation -> new PageMutation(name, Collections.singletonList(new PageElementMutation(name, (AreaMutation)areaMutation)))).collect(Collectors.toList());
    }

    private static Predicate<Map.Entry<String, PageElement>> nonViewport() {
        return e -> !((String)e.getKey()).equals("viewport");
    }
}

