/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.generator;

import com.galenframework.generator.PageItem;
import com.galenframework.generator.PageItemJsonMapper;
import com.galenframework.generator.PageItemNode;
import com.galenframework.generator.PageSpecGenerationResult;
import com.galenframework.generator.Size;
import com.galenframework.generator.SpecStatement;
import com.galenframework.generator.SpecSuggester;
import com.galenframework.generator.SuggestionOptions;
import com.galenframework.generator.SuggestionTestResult;
import com.galenframework.generator.builders.SpecGeneratorOptions;
import com.galenframework.generator.model.GmPageSpec;
import com.galenframework.page.Point;
import com.galenframework.page.Rect;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.stream.Collectors;

public class SpecGenerator {
    private PageItemJsonMapper piJsonMapper = new PageItemJsonMapper();

    public PageSpecGenerationResult generate(InputStream stream, SpecGeneratorOptions specGeneratorOptions) throws IOException {
        List<PageItem> pageItems = this.piJsonMapper.loadItems(stream);
        return this.generate(pageItems, specGeneratorOptions);
    }

    private PageSpecGenerationResult generate(List<PageItem> pageItems, SpecGeneratorOptions specGeneratorOptions) {
        Set<String> allObjectNames = this.extractItemNamesOnAllPages(pageItems);
        return this.generate(pageItems, allObjectNames, specGeneratorOptions);
    }

    private Set<String> extractItemNamesOnAllPages(List<PageItem> pageItems) {
        return pageItems.stream().map(PageItem::getName).distinct().collect(Collectors.toSet());
    }

    private PageSpecGenerationResult generate(List<PageItem> pageItems, Set<String> allObjectNames, SpecGeneratorOptions specGeneratorOptions) {
        LinkedList<PageItem> convertedItems = new LinkedList<PageItem>();
        PageItem screenItem = null;
        Size largestSize = new Size();
        for (PageItem pageItem : pageItems) {
            if ("viewport".equals(pageItem.getName())) continue;
            convertedItems.add(pageItem);
            if (screenItem == null && "screen".equals(pageItem.getName())) {
                screenItem = pageItem;
            }
            if (largestSize.width >= pageItem.getArea().getWidth()) continue;
            largestSize.width = pageItem.getArea().getWidth();
            largestSize.height = pageItem.getArea().getHeight();
        }
        convertedItems.sort(this.bySizeAndLocation());
        this.removeDuplicatedElements(convertedItems);
        List<PageItemNode> rootPins = this.restructurePageItems(convertedItems);
        LinkedList<String> objectNamesPerPage = new LinkedList<String>();
        rootPins.forEach(p -> p.visitTree(pin -> {
            objectNamesPerPage.add(pin.getPageItem().getName());
            if (pin.getChildren() != null) {
                this.sortPinsHorizontally(pin.getChildren());
            }
        }));
        SuggestionTestResult results = new SuggestionTestResult();
        rootPins.forEach(p -> p.visitTree(pin -> results.merge(this.proposeSpecsFor((PageItemNode)pin, objectNamesPerPage, specGeneratorOptions))));
        List<String> missingObjects = this.proposeAbsenseSpecs(results, pageItems, allObjectNames);
        missingObjects.forEach(missingObjectName -> {
            new PageItemNode(new PageItem((String)missingObjectName)).moveToParent((PageItemNode)rootPins.get(0));
            objectNamesPerPage.add((String)missingObjectName);
        });
        return new PageSpecGenerationResult(largestSize, objectNamesPerPage, rootPins, results);
    }

    private List<String> proposeAbsenseSpecs(SuggestionTestResult results, List<PageItem> pageItems, Set<String> allObjectNames) {
        Set allItemsOnCurrentPage = pageItems.stream().map(PageItem::getName).collect(Collectors.toSet());
        LinkedList<String> missingObjectNames = new LinkedList<String>();
        allObjectNames.stream().filter(itemName -> !allItemsOnCurrentPage.contains(itemName)).forEach(itemName -> {
            results.getGeneratedObjectSpecs().put((String)itemName, Collections.singletonList(new SpecStatement("absent")));
            missingObjectNames.add((String)itemName);
        });
        return missingObjectNames;
    }

    private void removeDuplicatedElements(List<PageItem> convertedItems) {
        ListIterator<PageItem> it = convertedItems.listIterator();
        if (it.hasNext()) {
            PageItem item = it.next();
            while (it.hasNext()) {
                PageItem nextItem = it.next();
                if (nextItem.getArea().equals(item.getArea())) {
                    it.remove();
                    continue;
                }
                item = nextItem;
            }
        }
    }

    private Comparator<PageItem> bySizeAndLocation() {
        return (a, b) -> {
            int size = a.getArea().getWidth() * a.getArea().getHeight() - b.getArea().getWidth() * b.getArea().getHeight();
            if (size != 0) {
                return size;
            }
            int diff = a.getArea().getLeft() - b.getArea().getLeft();
            if (diff != 0) {
                return diff;
            }
            return a.getArea().getTop() - b.getArea().getTop();
        };
    }

    private List<PageItemNode> restructurePageItems(List<PageItem> items) {
        List pins = items.stream().map(PageItemNode::new).collect(Collectors.toList());
        block0: for (PageItemNode pinA : pins) {
            for (PageItemNode pinB : pins) {
                if (pinA == pinB || !this.isInside(pinA.getPageItem().getArea(), pinB.getPageItem().getArea())) continue;
                if (pinB.getParent() == pinA) {
                    throw new RuntimeException(String.format("The following objects have identical areas: %s, %s. Please remove one of the objects", pinA.getPageItem().getName(), pinB.getPageItem().getName()));
                }
                pinA.moveToParent(pinB);
                continue block0;
            }
        }
        return pins.stream().filter(pin -> pin.getParent() == null && pin.getChildren().size() > 0).collect(Collectors.toList());
    }

    private SuggestionTestResult proposeSpecsFor(PageItemNode pin, List<String> objectNamesPerPage, SpecGeneratorOptions specGeneratorOptions) {
        SuggestionTestResult allResults = new SuggestionTestResult();
        SpecSuggester specSuggester = new SpecSuggester(new SuggestionOptions(objectNamesPerPage));
        if (pin.getParent() != null) {
            allResults.merge(specSuggester.suggestSpecsForTwoObjects(Arrays.asList(pin.getParent(), pin), SpecSuggester.parentSuggestions, specGeneratorOptions));
        }
        if (pin.getChildren() != null && !pin.getChildren().isEmpty()) {
            List<PageItemNode> horizontallySortedPins = pin.getChildren();
            List<PageItemNode> verticallySortedPins = this.copySortedVertically(pin.getChildren());
            if (specGeneratorOptions.isUseGalenExtras()) {
                allResults.merge(specSuggester.suggestSpecsForMultipleObjects(horizontallySortedPins, SpecSuggester.horizontallyOrderComplexRulesSuggestions, specGeneratorOptions));
                allResults.merge(specSuggester.suggestSpecsForMultipleObjects(verticallySortedPins, SpecSuggester.verticallyOrderComplexRulesSuggestions, specGeneratorOptions));
            }
            allResults.merge(specSuggester.suggestSpecsRayCasting(pin, horizontallySortedPins, specGeneratorOptions));
            allResults.merge(specSuggester.suggestSpecsForSingleObject(horizontallySortedPins, SpecSuggester.singleItemSuggestions, specGeneratorOptions));
        }
        return allResults;
    }

    private void sortPinsHorizontally(List<PageItemNode> pins) {
        Collections.sort(pins, (a, b) -> {
            int ax = a.getPageItem().getArea().getLeft();
            int ay = a.getPageItem().getArea().getTop();
            int bx = b.getPageItem().getArea().getLeft();
            int by = b.getPageItem().getArea().getTop();
            if (ax != bx) {
                return ax - bx;
            }
            return ay - by;
        });
    }

    private List<PageItemNode> copySortedVertically(List<PageItemNode> pins) {
        ArrayList<PageItemNode> sortedPins = new ArrayList<PageItemNode>(pins);
        Collections.sort(sortedPins, (a, b) -> {
            int ax = a.getPageItem().getArea().getLeft();
            int ay = a.getPageItem().getArea().getTop();
            int bx = b.getPageItem().getArea().getLeft();
            int by = b.getPageItem().getArea().getTop();
            if (ay != by) {
                return ay - by;
            }
            return ax - bx;
        });
        return sortedPins;
    }

    private boolean isInside(Rect area, Rect areaParent) {
        for (Point p : area.getPoints()) {
            if (areaParent.contains(p)) continue;
            return false;
        }
        return true;
    }

    public static String generateSpecSections(PageSpecGenerationResult result) {
        StringBuilder finalSpec = new StringBuilder();
        GmPageSpec pageSpecGM = GmPageSpec.create(result);
        finalSpec.append(pageSpecGM.render());
        return finalSpec.toString();
    }

    public static String generatePageSpec(PageSpecGenerationResult result, SpecGeneratorOptions specGeneratorOptions) {
        StringBuilder builder = new StringBuilder();
        if (specGeneratorOptions.isUseGalenExtras()) {
            builder.append("@lib galen-extras\n\n");
        }
        return builder.append(SpecGenerator.generateSpecSections(result)).toString();
    }
}

