/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.generator.builders;

import com.galenframework.generator.AssertionEdge;
import com.galenframework.generator.PageItem;
import com.galenframework.generator.SpecAssertion;
import com.galenframework.generator.SpecStatement;
import com.galenframework.generator.builders.AbstractSpecBuilder;
import com.galenframework.generator.builders.SpecGeneratorOptions;
import com.galenframework.generator.filters.SpecFilter;
import com.galenframework.generator.raycast.EdgesContainer;
import java.util.Collections;
import java.util.List;

public class SpecBuilderBelow
extends AbstractSpecBuilder {
    public static final String S_BELOW = "s_below";
    private final EdgesContainer.Edge topEdge;
    private final PageItem pageItem;

    public SpecBuilderBelow(PageItem pageItem, EdgesContainer.Edge topEdge) {
        this.pageItem = pageItem;
        this.topEdge = topEdge;
    }

    @Override
    public List<SpecStatement> buildSpecs(List<SpecFilter> excludedFilters, SpecGeneratorOptions options) {
        StringBuilder s = new StringBuilder("below ");
        s.append(this.topEdge.itemNode.getPageItem().getName());
        int distance = this.pageItem.getArea().getTop() - this.topEdge.p1.getTop();
        if (distance <= options.getMinimalStickyVerticalDistance()) {
            s.append(' ').append(distance).append("px");
        }
        this.extendSpecFilters(excludedFilters, "s_above");
        return Collections.singletonList(new SpecStatement(s.toString(), Collections.singletonList(new SpecAssertion(AssertionEdge.top(this.pageItem.getName()), AssertionEdge.bottom(this.topEdge)))));
    }

    @Override
    public String getName() {
        return S_BELOW;
    }

    @Override
    public String[] getArgs() {
        return new String[]{this.pageItem.getName(), this.topEdge.itemNode.getPageItem().getName()};
    }
}

