/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.generator.model;

import com.galenframework.generator.PageSpecGenerationResult;
import com.galenframework.generator.SpecStatement;
import com.galenframework.generator.model.GmObjectSpecs;
import com.galenframework.generator.model.GmPageSection;
import com.galenframework.generator.model.GmSpec;
import com.galenframework.generator.model.GmSpecRule;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class GmPageSpec {
    private List<GmPageSection> sections = new LinkedList<GmPageSection>();

    public static GmPageSpec create(PageSpecGenerationResult result) {
        GmPageSpec pageSpec = new GmPageSpec();
        GmPageSection skeletonSection = pageSpec.createNewSection("Skeleton");
        HashMap pinPageSections = new HashMap();
        result.getObjects().forEach(rootObject -> rootObject.getChildren().forEach(bigPin -> {
            GmPageSection pageSection = pageSpec.createNewSection(bigPin.getPageItem().getName() + " elements");
            bigPin.visitTree(p -> {
                if (p == bigPin) {
                    pinPageSections.put(p, skeletonSection);
                } else {
                    pinPageSections.put(p, pageSection);
                }
            });
        }));
        Map<String, List<SpecStatement>> generatedRules = result.getSuggestionResults().getGeneratedRules();
        Map<String, List<SpecStatement>> generatedObjectSpecs = result.getSuggestionResults().getGeneratedObjectSpecs();
        result.getObjects().forEach(p -> p.visitTree(pin -> {
            List specs;
            List rules;
            GmPageSection pageSection = (GmPageSection)pinPageSections.get(pin);
            if (generatedRules != null && (rules = (List)generatedRules.get(pin.getPageItem().getName())) != null) {
                rules.forEach(rule -> pageSection.getRules().add(new GmSpecRule(rule.getStatement())));
            }
            if (generatedObjectSpecs != null && !generatedObjectSpecs.isEmpty() && (specs = (List)generatedObjectSpecs.get(pin.getPageItem().getName())) != null && !specs.isEmpty()) {
                GmObjectSpecs objectSpecs = new GmObjectSpecs(pin.getPageItem().getName());
                pageSection.getObjectSpecs().add(objectSpecs);
                specs.forEach(spec -> objectSpecs.getSpecs().add(new GmSpec(spec.getStatement())));
            }
        }));
        pageSpec.setSections(pageSpec.getSections().stream().map(GmPageSection::optimizeSection).collect(Collectors.toList()));
        pinPageSections.values().forEach(section -> section.getObjectSpecs().forEach(objectSpecs -> Collections.sort(objectSpecs.getSpecs(), GmPageSpec.bySpecStatement())));
        return pageSpec;
    }

    private static Comparator<GmSpec> bySpecStatement() {
        return (a, b) -> a.getStatement().compareTo(b.getStatement());
    }

    private GmPageSection createNewSection(String name) {
        GmPageSection pageSection = new GmPageSection(name);
        this.getSections().add(pageSection);
        return pageSection;
    }

    public List<GmPageSection> getSections() {
        return this.sections;
    }

    public void setSections(List<GmPageSection> sections) {
        this.sections = sections;
    }

    public String render() {
        Configuration freemarkerConfiguration = new Configuration();
        HashMap<String, GmPageSpec> model = new HashMap<String, GmPageSpec>();
        model.put("pageSpec", this);
        try {
            Template template = new Template("report-main", (Reader)new InputStreamReader(this.getClass().getResourceAsStream("/generator/page-spec.gspec.ftl")), freemarkerConfiguration);
            StringWriter sw = new StringWriter();
            template.process(model, (Writer)sw);
            sw.flush();
            sw.close();
            return sw.toString();
        }
        catch (Exception ex) {
            throw new RuntimeException("Error rendering template", ex);
        }
    }
}

