/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.generator.raycast;

import com.galenframework.generator.PageItemNode;
import com.galenframework.page.Point;
import java.util.LinkedList;
import java.util.List;

public class EdgesContainer {
    private final List<Edge> rightEdges;
    private final List<Edge> leftEdges;
    private final List<Edge> bottomEdges;
    private final List<Edge> topEdges;

    public EdgesContainer(List<Edge> rightEdges, List<Edge> leftEdges, List<Edge> bottomEdges, List<Edge> topEdges) {
        this.rightEdges = rightEdges;
        this.leftEdges = leftEdges;
        this.bottomEdges = bottomEdges;
        this.topEdges = topEdges;
    }

    public List<Edge> getRightEdges() {
        return this.rightEdges;
    }

    public List<Edge> getLeftEdges() {
        return this.leftEdges;
    }

    public List<Edge> getBottomEdges() {
        return this.bottomEdges;
    }

    public List<Edge> getTopEdges() {
        return this.topEdges;
    }

    public static EdgesContainer create(PageItemNode parent, List<PageItemNode> pins) {
        LinkedList<Edge> rightEdges = new LinkedList<Edge>();
        LinkedList<Edge> leftEdges = new LinkedList<Edge>();
        LinkedList<Edge> bottomEdges = new LinkedList<Edge>();
        LinkedList<Edge> topEdges = new LinkedList<Edge>();
        Point[] parentPoints = parent.getPageItem().getArea().getPoints();
        rightEdges.add(new Edge(parent, parentPoints[1], parentPoints[2], true));
        leftEdges.add(new Edge(parent, parentPoints[0], parentPoints[3], true));
        topEdges.add(new Edge(parent, parentPoints[0], parentPoints[1], true));
        bottomEdges.add(new Edge(parent, parentPoints[3], parentPoints[2], true));
        for (PageItemNode pin : pins) {
            Point[] p = pin.getPageItem().getArea().getPoints();
            rightEdges.add(new Edge(pin, p[0], p[3], true));
            leftEdges.add(new Edge(pin, p[1], p[2], true));
            topEdges.add(new Edge(pin, p[3], p[2], true));
            bottomEdges.add(new Edge(pin, p[0], p[1], true));
        }
        return new EdgesContainer(rightEdges, leftEdges, bottomEdges, topEdges);
    }

    public static class Edge {
        public final PageItemNode itemNode;
        public final boolean isParent;
        public final Point p1;
        public final Point p2;

        public Edge(PageItemNode itemNode, Point p1, Point p2, boolean isParent) {
            this.itemNode = itemNode;
            this.isParent = isParent;
            this.p1 = p1;
            this.p2 = p2;
        }

        public Edge(PageItemNode itemNode, Point p1, Point p2) {
            this(itemNode, p1, p2, false);
        }

        public boolean isInRightZoneOf(Edge edge) {
            return this.p1.getLeft() >= edge.p1.getLeft() && this.isInHorizontalZoneOf(edge);
        }

        public boolean isInLeftZoneOf(Edge edge) {
            return this.p1.getLeft() <= edge.p1.getLeft() && this.isInHorizontalZoneOf(edge);
        }

        private boolean isInHorizontalZoneOf(Edge edge) {
            int zone2;
            int zone1 = this.identifyHorizontalZoneId(this.p1.getTop(), edge);
            return zone1 != (zone2 = this.identifyHorizontalZoneId(this.p2.getTop(), edge)) || zone1 == 0;
        }

        private int identifyHorizontalZoneId(int top, Edge edge) {
            if (top <= edge.p1.getTop()) {
                return -1;
            }
            if (top >= edge.p2.getTop()) {
                return 1;
            }
            return 0;
        }

        public boolean isInBottomZoneOf(Edge edge) {
            return this.p1.getTop() >= edge.p1.getTop() && this.isInVerticalZoneOf(edge);
        }

        public boolean isInTopZoneOf(Edge edge) {
            return this.p1.getTop() <= edge.p1.getTop() && this.isInVerticalZoneOf(edge);
        }

        private boolean isInVerticalZoneOf(Edge edge) {
            int zone2;
            int zone1 = this.identifyVerticalZoneId(this.p1.getLeft(), edge);
            return zone1 != (zone2 = this.identifyVerticalZoneId(this.p2.getLeft(), edge)) || zone1 == 0;
        }

        private int identifyVerticalZoneId(int left, Edge edge) {
            if (left <= edge.p1.getLeft()) {
                return -1;
            }
            if (left >= edge.p2.getLeft()) {
                return 1;
            }
            return 0;
        }
    }
}

