/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.generator.suggestions;

import com.galenframework.generator.AssertionEdge;
import com.galenframework.generator.SuggestionTestResult;
import com.galenframework.generator.filters.AnyTwoArgsSpecFilter;
import com.galenframework.generator.suggestions.AbstractRuleAlignSpecSuggestion;
import com.galenframework.page.Rect;
import java.util.List;

public class RuleHAlignSpecSuggestion
extends AbstractRuleAlignSpecSuggestion {
    public static final String R_H_ALIGN = "r_h_align";

    @Override
    public String getName() {
        return R_H_ALIGN;
    }

    @Override
    protected AssertionEdge.EdgeType nextEdgeType() {
        return AssertionEdge.EdgeType.left;
    }

    @Override
    protected AssertionEdge.EdgeType previousEdgeType() {
        return AssertionEdge.EdgeType.right;
    }

    @Override
    protected String getAlignmentWay() {
        return "horizontally next to each other";
    }

    @Override
    protected SuggestionTestResult enrichWithFilters(SuggestionTestResult suggestionTestResult, List<String> filterArgs) {
        return suggestionTestResult.addFilter(new AnyTwoArgsSpecFilter(R_H_ALIGN, filterArgs)).addFilter(new AnyTwoArgsSpecFilter("s_left_of", filterArgs)).addFilter(new AnyTwoArgsSpecFilter("s_right_of", filterArgs)).addFilter(new AnyTwoArgsSpecFilter("s_h_align", filterArgs)).addFilter(new AnyTwoArgsSpecFilter("s_centered_inside", filterArgs));
    }

    @Override
    protected int calculateDiff(Rect area1, Rect area2) {
        return area2.getLeft() - area1.getRight();
    }

    @Override
    protected boolean areAligned(Rect area1, Rect area2) {
        return area1.getTop() != area2.getTop() || area1.getBottom() != area2.getBottom();
    }
}

