/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.javascript;

import com.galenframework.api.Galen;
import com.galenframework.api.GalenPageDump;
import com.galenframework.javascript.GalenJsApi;
import com.galenframework.javascript.JsFunctionLoad;
import com.galenframework.parser.VarsParserJsProcessable;
import com.galenframework.runner.events.TestEvent;
import com.galenframework.runner.events.TestFilterEvent;
import com.galenframework.runner.events.TestRetryEvent;
import com.galenframework.runner.events.TestSuiteEvent;
import com.galenframework.suite.actions.mutation.MutationOptions;
import com.galenframework.tests.GalenTest;
import com.galenframework.tests.TestSession;
import com.galenframework.utils.GalenUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.apache.commons.io.IOUtils;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GalenJsExecutor
implements VarsParserJsProcessable {
    private static final Logger LOG = LoggerFactory.getLogger(GalenJsExecutor.class);
    private Context context = Context.enter();
    private ImporterTopLevel scope = new ImporterTopLevel(this.context);
    private JsFunctionLoad loadFunction = new JsFunctionLoad();

    public GalenJsExecutor() {
        this.scope.defineProperty("load", (Object)this.loadFunction, 2);
        this.importAllMajorClasses();
    }

    private void importAllMajorClasses() {
        this.importClasses(new Class[]{Thread.class, By.class, WebElement.class, WebDriver.class, System.class, Actions.class, GalenTest.class, TestSession.class, GalenUtils.class, GalenJsApi.class, TestEvent.class, TestSuiteEvent.class, TestFilterEvent.class, TestRetryEvent.class, Galen.class, GalenPageDump.class, MutationOptions.class});
    }

    private void importClasses(Class<?>[] classes) {
        for (Class<?> clazz : classes) {
            this.context.evaluateString((Scriptable)this.scope, "importClass(" + clazz.getName() + ");", "<cmd>", 1, null);
        }
    }

    public void putObject(String name, Object object) {
        ScriptableObject.putProperty((Scriptable)this.scope, (String)name, (Object)Context.javaToJS((Object)object, (Scriptable)this.scope));
    }

    public Object eval(String jsCode) {
        return this.context.evaluateString((Scriptable)this.scope, jsCode, "<cmd>", 1, null);
    }

    public Object eval(Reader scriptFileReader, String javascriptPath) throws IOException {
        File file = new File(javascriptPath);
        this.loadFunction.putContextPath(file.getParent());
        return this.context.evaluateReader((Scriptable)this.scope, scriptFileReader, javascriptPath, 1, null);
    }

    private String unwrapProcessedObjectToString(Object returnedObject) {
        if (returnedObject != null) {
            if (returnedObject instanceof NativeJavaObject) {
                returnedObject = ((NativeJavaObject)returnedObject).unwrap();
            }
            if (returnedObject instanceof Double) {
                return Integer.toString(((Double)returnedObject).intValue());
            }
            if (returnedObject instanceof Float) {
                return Integer.toString(((Float)returnedObject).intValue());
            }
            return returnedObject.toString();
        }
        return null;
    }

    @Override
    public String evalStrictToString(String script) {
        Object returnedObject = this.context.evaluateString((Scriptable)this.scope, script, "<cmd>", 1, null);
        String unwrappedObject = this.unwrapProcessedObjectToString(returnedObject);
        if (unwrappedObject != null) {
            return unwrappedObject;
        }
        return "null";
    }

    public static String loadJsFromLibrary(String path) {
        try {
            InputStream is = GalenJsExecutor.class.getResourceAsStream("/js/" + path);
            return IOUtils.toString((InputStream)is);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String getVersion() {
        return ContextFactory.getGlobal().enterContext().getImplementationVersion();
    }

    public void runJavaScriptFromFile(String scriptPath) {
        this.loadFunction.load(scriptPath, this.context, (Scriptable)this.scope);
    }

    public void evalScriptFromLibrary(String libraryName) {
        this.eval(GalenJsExecutor.loadJsFromLibrary(libraryName));
    }

    public ImporterTopLevel getScope() {
        return this.scope;
    }
}

