/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.ocr;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.galenframework.config.GalenConfig;
import com.galenframework.config.GalenProperty;
import com.galenframework.ocr.OcrResult;
import com.galenframework.ocr.OcrService;
import com.galenframework.ocr.google.pojo.GoogleModel;
import com.galenframework.ocr.google.pojo.request.Feature;
import com.galenframework.ocr.google.pojo.request.GoogleRequest;
import com.galenframework.ocr.google.pojo.request.Image;
import com.galenframework.ocr.google.pojo.request.Request;
import com.galenframework.page.Rect;
import com.galenframework.validation.ValidationErrorException;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Base64;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClients;

public class GoogleVisionOcrService
implements OcrService {
    private static final String BASE_URL = "https://vision.googleapis.com/v1/images:annotate?key=";
    static final HttpClient httpClient = HttpClients.createDefault();
    static final ObjectMapper objectMapper = new ObjectMapper();

    @Override
    public OcrResult findOcrText(BufferedImage image, Rect rect) throws ValidationErrorException {
        if (rect.getRight() > image.getWidth() && rect.getBottom() > rect.getHeight()) {
            throw new ValidationErrorException("Could not extract element image. Looks like it is located outside of screenshot area");
        }
        try {
            BufferedImage croppedImage = image.getSubimage(rect.getLeft(), rect.getTop(), rect.getWidth(), rect.getHeight());
            GoogleModel model = GoogleVisionOcrService.getGoogleModel(croppedImage);
            if (model.responses != null && !model.responses.isEmpty()) {
                String resultedText = model.responses.get((int)0).fullTextAnnotation.text;
                if (resultedText == null) {
                    resultedText = "";
                }
                return new OcrResult(new String(resultedText.getBytes(Charset.forName("utf-8"))), rect);
            }
            throw new NullPointerException("Got empty result");
        }
        catch (Exception e) {
            throw new ValidationErrorException("Google vision API error: " + e.getMessage(), e);
        }
    }

    public static GoogleModel getGoogleModel(BufferedImage img) throws Exception {
        String key = GalenConfig.getConfig().readProperty(GalenProperty.GALEN_OCR_GOOGLE_VISION_KEY);
        if (key == null) {
            throw new RuntimeException("Missing property " + (Object)((Object)GalenProperty.GALEN_OCR_GOOGLE_VISION_KEY) + ". See https://cloud.google.com/vision/docs/auth for more info");
        }
        GoogleRequest grequest = new GoogleRequest();
        ArrayList<Request> requests = new ArrayList<Request>();
        Request request = new Request();
        requests.add(request);
        Image image = new Image();
        image.setContent(GoogleVisionOcrService.imgToBase64String(img, "PNG"));
        request.setImage(image);
        grequest.setRequests(requests);
        ArrayList<Feature> features = new ArrayList<Feature>();
        Feature feature = new Feature();
        feature.setType("TEXT_DETECTION");
        feature.setMaxResults(1);
        request.setFeatures(features);
        features.add(feature);
        return GoogleVisionOcrService.postOcrImage(key, grequest);
    }

    private static GoogleModel postOcrImage(String key, GoogleRequest grequest) throws IOException {
        String message;
        String url = BASE_URL + key;
        HttpResponse response = GoogleVisionOcrService.post(url, grequest);
        int status = response.getStatusLine().getStatusCode();
        String responseText = IOUtils.toString((InputStream)response.getEntity().getContent());
        if (status < 400) {
            System.out.println("\n" + responseText);
            return (GoogleModel)objectMapper.readValue(responseText, GoogleModel.class);
        }
        try {
            JsonNode tree = objectMapper.readTree(responseText);
            message = tree.get("error").get("message").asText();
        }
        catch (Exception ex) {
            message = responseText;
        }
        throw new IOException("Response " + status + ". " + message);
    }

    private static HttpResponse post(String url, Object requestObject) throws IOException {
        String json = objectMapper.writeValueAsString(requestObject);
        HttpPost httpPost = new HttpPost(url);
        httpPost.setEntity((HttpEntity)new StringEntity(json));
        httpPost.setHeader("Accept", "application/json");
        httpPost.setHeader("Content-type", "application/json");
        return httpClient.execute((HttpUriRequest)httpPost);
    }

    public static String imgToBase64String(RenderedImage img, String formatName) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            ImageIO.write(img, formatName, os);
            return Base64.getEncoder().encodeToString(os.toByteArray());
        }
        catch (IOException ioe) {
            throw new UncheckedIOException(ioe);
        }
    }
}

