/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.page.selenium;

import com.galenframework.config.GalenConfig;
import com.galenframework.config.GalenProperty;
import com.galenframework.page.Rect;
import com.galenframework.page.selenium.WebPageElement;
import java.util.List;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebElement;

public enum AreaFinder {
    NATIVE(new FindArea(){

        @Override
        public Rect findArea(WebPageElement webPageElement) {
            WebElement webElement = webPageElement.getWebElement();
            Point location = webElement.getLocation();
            Dimension size = webElement.getSize();
            return new Rect(location.getX(), location.getY(), size.getWidth(), size.getHeight());
        }
    }),
    JSBASED(new FindArea(){

        @Override
        public Rect findArea(WebPageElement webPageElement) {
            List rect = (List)((JavascriptExecutor)webPageElement.getDriver()).executeScript(AreaFinder.JSBASED_SCRIPT, new Object[]{webPageElement.getWebElement()});
            return new Rect(((Number)rect.get(0)).intValue(), ((Number)rect.get(1)).intValue(), ((Number)rect.get(2)).intValue(), ((Number)rect.get(3)).intValue());
        }
    }),
    JSBASED_NATIVE(new FindArea(){

        @Override
        public Rect findArea(WebPageElement webPageElement) {
            try {
                return JSBASED.findArea(webPageElement);
            }
            catch (Exception ex) {
                return NATIVE.findArea(webPageElement);
            }
        }
    }),
    CUSTOM(new FindArea(){

        @Override
        public Rect findArea(WebPageElement webPageElement) {
            String script = GalenConfig.getConfig().getStringProperty(GalenProperty.GALEN_BROWSER_PAGELEMENT_AREAFINDER_CUSTOM_SCRIPT);
            List rect = (List)((JavascriptExecutor)webPageElement.getDriver()).executeScript(script, new Object[]{webPageElement.getWebElement()});
            return new Rect(((Number)rect.get(0)).intValue(), ((Number)rect.get(1)).intValue(), ((Number)rect.get(2)).intValue(), ((Number)rect.get(3)).intValue());
        }
    });

    private final FindArea areaFinder;
    private static final String JSBASED_SCRIPT = "var element = arguments[0], scrollTop = window.pageYOffset || document.documentElement.scrollTop, scrollLeft = window.pageXOffset || document.documentElement.scrollLeft, rect = element.getBoundingClientRect(); return [rect.left + scrollLeft, rect.top + scrollTop, rect.width, rect.height];";

    private AreaFinder(FindArea findArea) {
        this.areaFinder = findArea;
    }

    public Rect findArea(WebPageElement webPageElement) {
        return this.areaFinder.findArea(webPageElement);
    }

    private static interface FindArea {
        public Rect findArea(WebPageElement var1);
    }
}

