/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.parser;

import com.galenframework.parser.Expectation;
import com.galenframework.parser.StringCharReader;
import java.util.ArrayList;

public class ExpectWord
implements Expectation<String> {
    private char[] delimeters = new char[]{' ', '\t', ','};
    private char[] breakSymbols = null;

    @Override
    public String read(StringCharReader reader) {
        boolean started = false;
        StringBuffer buffer = new StringBuffer();
        while (reader.hasMore()) {
            char symbol = reader.next();
            if (this.isBreaking(symbol)) {
                reader.back();
                break;
            }
            if (this.isWordDelimeter(symbol)) {
                if (!started) continue;
                reader.back();
                break;
            }
            buffer.append(symbol);
            started = true;
        }
        return buffer.toString();
    }

    private boolean isBreaking(char symbol) {
        if (this.breakSymbols != null) {
            for (char breakSymbol : this.breakSymbols) {
                if (breakSymbol != symbol) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isWordDelimeter(char symbol) {
        for (char delimeter : this.delimeters) {
            if (symbol != delimeter) continue;
            return true;
        }
        return false;
    }

    public ExpectWord stopOnTheseSymbols(char ... breakSymbols) {
        this.breakSymbols = breakSymbols;
        return this;
    }

    public ExpectWord withDelimeters(char ... delimeters) {
        this.delimeters = delimeters;
        return this;
    }

    public static String read(String line) {
        return new ExpectWord().read(new StringCharReader(line));
    }

    public static String[] readAllWords(StringCharReader reader) {
        String word;
        ArrayList<String> words = new ArrayList<String>();
        while (reader.hasMore() && !(word = new ExpectWord().read(reader)).isEmpty()) {
            words.add(word);
        }
        return words.toArray(new String[0]);
    }
}

