/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.parser;

import com.galenframework.browser.JsBrowserFactory;
import com.galenframework.browser.SeleniumBrowserFactory;
import com.galenframework.browser.SeleniumGridBrowserFactory;
import com.galenframework.parser.CommandLineParser;
import com.galenframework.parser.GalenCommand;
import com.galenframework.parser.GalenCommandLineParser;
import com.galenframework.parser.SyntaxException;
import com.galenframework.specs.Place;
import com.galenframework.suite.GalenPageTest;
import com.galenframework.utils.GalenUtils;
import java.util.List;
import org.openqa.selenium.Platform;

public class GalenPageTestReader {
    public static GalenPageTest readFrom(String text, Place line) {
        String[] args;
        String title = text.trim();
        if (text.contains("|")) {
            String[] values = text.split("\\|");
            title = values[0].trim();
            text = values[1];
        }
        if ((args = CommandLineParser.parseCommandLine(text)).length == 0) {
            throw new SyntaxException(line, "Incorrect amount of arguments: " + text.trim());
        }
        if (GalenUtils.isUrl(args[0])) {
            String size = null;
            if (args.length > 1) {
                size = args[1];
            }
            return GalenPageTestReader.defaultGalenPageTest(title, args[0], size);
        }
        String first = args[0].toLowerCase();
        if (first.equals("selenium")) {
            return GalenPageTestReader.seleniumGalenPageTest(title, args, text.trim(), line);
        }
        if (first.equals("jsfactory")) {
            return GalenPageTestReader.jsBrowserFactory(title, args);
        }
        throw new SyntaxException(line, "Unknown browser factory: " + first);
    }

    private static GalenPageTest jsBrowserFactory(String title, String[] args) {
        if (args.length < 2) {
            throw new SyntaxException("Missing script path");
        }
        return new GalenPageTest().withBrowserFactory(new JsBrowserFactory(args[1], GalenPageTestReader.stripFirst(2, args))).withTitle(title);
    }

    private static GalenPageTest seleniumGalenPageTest(String title, String[] args, String originalText, Place line) {
        if (args.length < 3) {
            throw new SyntaxException(line, "Incorrect amount of arguments: " + originalText);
        }
        String seleniumType = args[1].toLowerCase();
        if ("grid".equals(seleniumType)) {
            return GalenPageTestReader.gridGalenPageTest(GalenPageTestReader.stripFirst(2, args), originalText, line);
        }
        String size = null;
        if (args.length > 3) {
            size = args[3];
        }
        return GalenPageTestReader.seleniumSimpleGalenPageTest(title, seleniumType, args[2], size);
    }

    private static String[] stripFirst(int number, String[] args) {
        if (number > 0 && number < args.length) {
            String[] newArgs = new String[args.length - number];
            for (int i = number; i < args.length; ++i) {
                newArgs[i - number] = args[i];
            }
            return newArgs;
        }
        return args;
    }

    private static GalenPageTest gridGalenPageTest(String[] args, String originalText, Place place) {
        GalenCommand command = new GalenCommandLineParser().parse(args);
        List<String> leftovers = command.getLeftovers();
        if (leftovers.size() == 0) {
            throw new SyntaxException(place, "Cannot parse grid arguments: " + originalText);
        }
        String gridUrl = leftovers.get(0);
        String pageUrl = command.get("page");
        String size = command.get("size");
        SeleniumGridBrowserFactory browserFactory = new SeleniumGridBrowserFactory(gridUrl).withBrowser(command.get("browser")).withBrowserVersion(command.get("version")).withPlatform(GalenPageTestReader.readPlatform(command.get("platform")));
        for (String parameter : command.getParameterNames()) {
            if (!parameter.startsWith("dc.")) continue;
            String desiredCapaibility = parameter.substring(3);
            browserFactory.withDesiredCapability(desiredCapaibility, command.get(parameter));
        }
        return new GalenPageTest().withUrl(pageUrl).withSize(GalenUtils.readSize(size)).withBrowserFactory(browserFactory);
    }

    private static Platform readPlatform(String platformText) {
        if (platformText == null) {
            return null;
        }
        return Platform.valueOf((String)platformText.toUpperCase());
    }

    private static GalenPageTest seleniumSimpleGalenPageTest(String title, String browser, String url, String screenSize) {
        if (url.equals("-")) {
            url = null;
        }
        return new GalenPageTest().withTitle(title).withUrl(url).withSize(GalenUtils.readSize(screenSize)).withBrowserFactory(new SeleniumBrowserFactory(browser));
    }

    private static GalenPageTest defaultGalenPageTest(String title, String url, String sizeText) {
        if (url.equals("-")) {
            url = null;
        }
        return new GalenPageTest().withTitle(title).withUrl(url).withSize(GalenUtils.readSize(sizeText)).withBrowserFactory(new SeleniumBrowserFactory());
    }
}

