/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.parser;

import com.galenframework.parser.StructNode;
import com.galenframework.parser.SyntaxException;
import com.galenframework.specs.Place;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Stack;
import org.apache.commons.io.IOUtils;

public class IndentationStructureParser {
    public static final String COMMENT_SYMBOL = "#";
    private static final char SPACE = ' ';
    private static final char TAB = '\t';
    private static final int TAB_SIZE = 4;

    public List<StructNode> parse(String contentWithTabs) throws IOException {
        return this.parse(new ByteArrayInputStream(contentWithTabs.getBytes()), "<unknown>");
    }

    public List<StructNode> parse(InputStream stream, String source) throws IOException {
        Stack<IndentationNode> nodeStack = new Stack<IndentationNode>();
        StructNode rootNode = new StructNode();
        nodeStack.push(new IndentationNode(-1, rootNode, null));
        List lines = IOUtils.readLines((InputStream)stream);
        int lineNumber = 0;
        for (String line : lines) {
            ++lineNumber;
            if (!this.isProcessable(line)) continue;
            this.processPlace(nodeStack, line, lineNumber, source);
        }
        return rootNode.getChildNodes();
    }

    private void processPlace(Stack<IndentationNode> stack, String text, int lineNumber, String source) {
        StructNode newStructNode = new StructNode(text.trim());
        newStructNode.setPlace(new Place(source, lineNumber));
        int calculatedIndentation = this.calculateIndentation(text, lineNumber);
        while (calculatedIndentation <= stack.peek().indentation && stack.peek().parent != null) {
            stack.pop();
        }
        StructNode parent = stack.peek().structNode;
        if (parent.getChildNodes() != null && parent.getChildNodes().size() > 0 && calculatedIndentation != stack.peek().childIndentation) {
            throw new SyntaxException(new Place(source, lineNumber), "Inconsistent indentation");
        }
        parent.addChildNode(newStructNode);
        stack.peek().childIndentation = calculatedIndentation;
        stack.push(new IndentationNode(calculatedIndentation, newStructNode, parent));
    }

    private int calculateIndentation(String line, int lineNumber) {
        int indentation = 0;
        for (int i = 0; i < line.length(); ++i) {
            char symbol = line.charAt(i);
            if (symbol == ' ') {
                ++indentation;
                continue;
            }
            if (symbol == '\t') {
                indentation += 4;
                continue;
            }
            return indentation;
        }
        throw new SyntaxException(new Place(line, lineNumber), "This line does not have any text");
    }

    private boolean isProcessable(String line) {
        String trimmed = line.trim();
        return !trimmed.isEmpty() && !trimmed.startsWith(COMMENT_SYMBOL);
    }

    private static class IndentationNode {
        private final StructNode parent;
        private final Integer indentation;
        private final StructNode structNode;
        private int childIndentation = 0;

        public IndentationNode(Integer indentation, StructNode structNode, StructNode parent) {
            this.indentation = indentation;
            this.structNode = structNode;
            this.parent = parent;
        }

        public String toString() {
            return this.structNode.getName() + " #" + this.indentation;
        }
    }
}

