/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.parser;

import com.galenframework.javascript.GalenJsExecutor;
import com.galenframework.parser.StringCharReader;
import com.galenframework.parser.SyntaxException;

public class MathParser {
    private char mathSymbol = (char)64;
    private static final char[] mathOperations = new char[]{'+', '-', '/', '*', '%'};

    public String parse(String template, String initialValue) {
        StringCharReader reader = new StringCharReader(template);
        StringBuffer text = new StringBuffer();
        while (reader.hasMore()) {
            char ch = reader.next();
            if (ch == this.mathSymbol) {
                if (reader.hasMore()) {
                    char nextCh = reader.next();
                    if (nextCh == this.mathSymbol) {
                        text.append(this.mathSymbol);
                        continue;
                    }
                    if (nextCh == '{') {
                        String expression = reader.readSafeUntilSymbol('}').replace(" ", "");
                        if (expression.length() < 2) {
                            throw new SyntaxException("Can't parse expression: " + expression);
                        }
                        text.append(this.convertExpression(initialValue, expression));
                        continue;
                    }
                    text.append(initialValue);
                    text.append(nextCh);
                    continue;
                }
                text.append(initialValue);
                continue;
            }
            text.append(ch);
        }
        return text.toString();
    }

    private String convertExpression(String initialValue, String expression) {
        int index = Integer.parseInt(initialValue);
        if (this.startsWithOneOfTheseSymbols(expression, mathOperations)) {
            expression = "index" + expression;
        }
        return Integer.toString(this.execJavascript(index, expression));
    }

    private int execJavascript(int index, String expression) {
        GalenJsExecutor jsExecutor = new GalenJsExecutor();
        jsExecutor.putObject("index", index);
        Number number = (Number)jsExecutor.eval(expression);
        return number.intValue();
    }

    private boolean startsWithOneOfTheseSymbols(String expression, char[] mathOperations) {
        if (expression.length() > 0) {
            char firstSymbol = expression.charAt(0);
            for (char symbol : mathOperations) {
                if (firstSymbol != symbol) continue;
                return true;
            }
        }
        return false;
    }
}

