/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.reports;

import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.galenframework.reports.GalenTestInfo;
import com.galenframework.reports.TestStatistic;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class GalenTestAggregatedInfo {
    @JsonUnwrapped
    private GalenTestInfo testInfo;
    private TestStatistic statistic;
    private String testId;

    public GalenTestAggregatedInfo() {
    }

    public GalenTestAggregatedInfo(String testId, GalenTestInfo test) {
        this.setTestInfo(test);
        this.setStatistic(test.getReport().fetchStatistic());
        this.setTestId(testId);
    }

    public boolean getFailed() {
        return this.testInfo.getException() != null || this.statistic.getErrors() > 0;
    }

    public GalenTestInfo getTestInfo() {
        return this.testInfo;
    }

    public void setTestInfo(GalenTestInfo testInfo) {
        this.testInfo = testInfo;
    }

    public TestStatistic getStatistic() {
        return this.statistic;
    }

    public void setStatistic(TestStatistic statistic) {
        this.statistic = statistic;
    }

    public String getTestId() {
        return this.testId;
    }

    public void setTestId(String testId) {
        this.testId = testId;
    }

    public String getExceptionMessage() {
        if (this.testInfo.getException() != null) {
            return ExceptionUtils.getMessage((Throwable)this.testInfo.getException());
        }
        return null;
    }

    public String getExceptionStacktrace() {
        if (this.testInfo.getException() != null) {
            return ExceptionUtils.getStackTrace((Throwable)this.testInfo.getException());
        }
        return null;
    }

    public Long getDuration() {
        return this.testInfo.getEndedAt().getTime() - this.testInfo.getStartedAt().getTime();
    }

    public List<String> getGroups() {
        if (this.testInfo.getTest() != null) {
            return this.testInfo.getTest().getGroups();
        }
        return null;
    }
}

