/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.reports;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.galenframework.reports.ExceptionReportNode;
import com.galenframework.reports.TestStatistic;
import com.galenframework.reports.model.FileTempStorage;
import com.galenframework.reports.model.LayoutReport;
import com.galenframework.reports.nodes.LayoutReportNode;
import com.galenframework.reports.nodes.TestReportNode;
import java.util.List;

public class TestReport {
    @JsonIgnore
    private FileTempStorage fileStorage = new FileTempStorage("file");
    private TestReportNode rootNode;
    private TestReportNode currentNode = this.rootNode = new TestReportNode(this.fileStorage);

    public TestReportNode info(String name) {
        TestReportNode node = new TestReportNode(this.fileStorage, name, TestReportNode.Status.INFO);
        this.currentNode.addNode(node);
        return node;
    }

    public TestReportNode warn(String name) {
        TestReportNode node = new TestReportNode(this.fileStorage, name, TestReportNode.Status.WARN);
        this.currentNode.addNode(node);
        return node;
    }

    public TestReportNode error(String name) {
        TestReportNode node = new TestReportNode(this.fileStorage, name, TestReportNode.Status.ERROR);
        this.currentNode.addNode(node);
        return node;
    }

    public List<TestReportNode> getNodes() {
        return this.rootNode.getNodes();
    }

    public TestReportNode sectionStart(String name) {
        TestReportNode node = new TestReportNode(this.fileStorage);
        node.setName(name);
        this.currentNode.addNode(node);
        this.currentNode = node;
        return node;
    }

    public void gotoRoot() {
        this.currentNode = this.rootNode;
    }

    public void sectionEnd() {
        if (this.currentNode.getParent() != null) {
            this.currentNode = this.currentNode.getParent();
        }
    }

    public TestReportNode error(Throwable ex) {
        ExceptionReportNode node = new ExceptionReportNode(this.fileStorage, ex);
        this.currentNode.addNode(node);
        return node;
    }

    public TestReportNode addNode(TestReportNode node) {
        this.currentNode.addNode(node);
        return node;
    }

    public LayoutReportNode layout(LayoutReport layoutReport, String title) {
        LayoutReportNode layoutReportNode = new LayoutReportNode(this.fileStorage, layoutReport, title);
        if (layoutReport.errors() > 0) {
            layoutReportNode.setStatus(TestReportNode.Status.ERROR);
        } else if (layoutReport.warnings() > 0) {
            layoutReportNode.setStatus(TestReportNode.Status.WARN);
        }
        this.currentNode.addNode(layoutReportNode);
        return layoutReportNode;
    }

    public TestStatistic fetchStatistic() {
        return this.rootNode.fetchStatistic(new TestStatistic());
    }

    public FileTempStorage getFileStorage() {
        return this.fileStorage;
    }
}

