/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.reports.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.galenframework.reports.GalenTestAggregatedInfo;
import com.galenframework.reports.GalenTestInfo;
import com.galenframework.reports.TestIdGenerator;
import com.galenframework.reports.TestReport;
import com.galenframework.reports.json.JsonTestReport;
import com.galenframework.reports.json.ReportOverview;
import com.galenframework.utils.GalenUtils;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class JsonReportBuilder {
    private ObjectMapper jsonMapper = this.createJsonMapper();
    private TestIdGenerator testIdGenerator = new TestIdGenerator();

    private ObjectMapper createJsonMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        return mapper;
    }

    public void build(List<GalenTestInfo> testInfos, String reportPath) throws IOException {
        ReportOverview reportOverview = this.createReportOverview(testInfos);
        for (GalenTestAggregatedInfo aggregatedInfo : reportOverview.getTests()) {
            this.exportTestReportToJson(new JsonTestReport(aggregatedInfo.getTestId(), aggregatedInfo.getTestInfo()), reportPath);
            this.moveAllReportFiles(aggregatedInfo.getTestInfo().getReport(), reportPath);
        }
        this.exportReportOverviewToJson(reportOverview, reportPath);
    }

    private void moveAllReportFiles(TestReport report, String reportPath) throws IOException {
        if (report != null && report.getFileStorage() != null) {
            report.getFileStorage().copyAllFilesTo(new File(reportPath));
        }
    }

    public ReportOverview createReportOverview(List<GalenTestInfo> testInfos) {
        ReportOverview reportOverview = new ReportOverview();
        for (GalenTestInfo testInfo : testInfos) {
            String testId = this.testIdGenerator.generateTestId(testInfo.getName());
            reportOverview.add(new GalenTestAggregatedInfo(testId, testInfo));
        }
        return reportOverview;
    }

    public String exportReportOverviewToJsonAsString(ReportOverview reportOverview) throws JsonProcessingException {
        return this.jsonMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)reportOverview);
    }

    private void exportReportOverviewToJson(ReportOverview reportOverview, String reportPath) throws IOException {
        GalenUtils.makeSureFolderExists(reportPath);
        File file = new File(reportPath + File.separator + "report.json");
        file.createNewFile();
        this.jsonMapper.writerWithDefaultPrettyPrinter().writeValue(file, (Object)reportOverview);
    }

    private void exportTestReportToJson(JsonTestReport aggregatedInfo, String reportPath) throws IOException {
        GalenUtils.makeSureFolderExists(reportPath);
        File file = new File(reportPath + File.separator + aggregatedInfo.getTestId() + ".json");
        file.createNewFile();
        this.jsonMapper.writerWithDefaultPrettyPrinter().writeValue(file, (Object)aggregatedInfo);
    }

    public String exportTestReportToJsonString(GalenTestAggregatedInfo info) throws JsonProcessingException {
        return this.jsonMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)new JsonTestReport(info.getTestId(), info.getTestInfo()));
    }
}

