/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.reports.model;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;

public class FileTempStorage {
    private final String storageName;
    private Map<String, File> files = new HashMap<String, File>();
    private List<FileTempStorage> childStorages = new LinkedList<FileTempStorage>();
    private static long _uniqueId = 0L;

    public FileTempStorage(String storageName) {
        this.storageName = storageName;
    }

    private static synchronized long getUniqueId() {
        return ++_uniqueId;
    }

    public String registerFile(String fileName, File file) {
        String uniqueName = this.storageName + "-" + FileTempStorage.getUniqueId() + "-" + fileName;
        this.files.put(uniqueName, file);
        return uniqueName;
    }

    public Map<String, File> getFiles() {
        return this.files;
    }

    public void copyAllFilesTo(File dir) throws IOException {
        for (Map.Entry<String, File> entry : this.files.entrySet()) {
            FileUtils.copyFile((File)entry.getValue(), (File)new File(dir.getAbsolutePath() + File.separator + entry.getKey()));
        }
        for (FileTempStorage storage : this.childStorages) {
            storage.copyAllFilesTo(dir);
        }
    }

    public void registerStorage(FileTempStorage fileStorage) {
        this.childStorages.add(fileStorage);
    }

    public void cleanup() {
        if (this.childStorages != null) {
            for (FileTempStorage storage : this.childStorages) {
                storage.cleanup();
            }
        }
        for (File file : this.files.values()) {
            FileUtils.deleteQuietly((File)file);
        }
        this.files.clear();
    }
}

