/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.reports.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.galenframework.reports.model.FileTempStorage;
import com.galenframework.reports.model.LayoutObjectDetails;
import com.galenframework.reports.model.LayoutSection;
import com.galenframework.validation.ValidationResult;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class LayoutReport {
    private String title;
    private List<String> includedTags = new ArrayList<String>();
    private List<String> excludedTags = new ArrayList<String>();
    private List<LayoutSection> sections = new LinkedList<LayoutSection>();
    private Map<String, LayoutObjectDetails> objects = new HashMap<String, LayoutObjectDetails>();
    private String screenshot;
    @JsonIgnore
    private List<ValidationResult> validationErrorResults;
    @JsonIgnore
    private FileTempStorage fileStorage = new FileTempStorage("layout");

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public List<LayoutSection> getSections() {
        return this.sections;
    }

    public void setSections(List<LayoutSection> sections) {
        this.sections = sections;
    }

    public String getScreenshot() {
        return this.screenshot;
    }

    public void setScreenshot(String screenshot) {
        this.screenshot = screenshot;
    }

    public void setValidationErrorResults(List<ValidationResult> validationErrorResults) {
        this.validationErrorResults = validationErrorResults;
    }

    public int errors() {
        int errors = 0;
        if (this.validationErrorResults != null) {
            for (ValidationResult validationError : this.validationErrorResults) {
                if (validationError.getError().isOnlyWarn()) continue;
                ++errors;
            }
        }
        return errors;
    }

    public int warnings() {
        int warnings = 0;
        if (this.validationErrorResults != null) {
            for (ValidationResult validationError : this.validationErrorResults) {
                if (!validationError.getError().isOnlyWarn()) continue;
                ++warnings;
            }
        }
        return warnings;
    }

    public List<ValidationResult> getValidationErrorResults() {
        return this.validationErrorResults;
    }

    public Map<String, LayoutObjectDetails> getObjects() {
        return this.objects;
    }

    public void setObjects(Map<String, LayoutObjectDetails> objects) {
        this.objects = objects;
    }

    public List<String> getIncludedTags() {
        return this.includedTags;
    }

    public void setIncludedTags(List<String> includedTags) {
        this.includedTags = includedTags;
    }

    public List<String> getExcludedTags() {
        return this.excludedTags;
    }

    public void setExcludedTags(List<String> excludedTags) {
        this.excludedTags = excludedTags;
    }

    public FileTempStorage getFileStorage() {
        return this.fileStorage;
    }

    public String registerFile(String fileName, File file) {
        return this.fileStorage.registerFile(fileName, file);
    }
}

