/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.reports.nodes;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonValue;
import com.galenframework.reports.TestStatistic;
import com.galenframework.reports.model.FileTempStorage;
import com.galenframework.reports.nodes.ReportExtra;
import com.galenframework.reports.nodes.ReportExtraFile;
import com.galenframework.reports.nodes.ReportExtraImage;
import com.galenframework.reports.nodes.ReportExtraLink;
import com.galenframework.reports.nodes.ReportExtraText;
import com.galenframework.reports.nodes.TextReportNode;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;

public class TestReportNode {
    @JsonIgnore
    private final FileTempStorage fileStorage;
    private String name;
    private Status status = Status.INFO;
    private List<TestReportNode> nodes;
    @JsonIgnore
    private TestReportNode parent;
    private List<String> attachments;
    private Date time = new Date();
    private Map<String, ReportExtra> extras;

    public TestReportNode(FileTempStorage fileStorage) {
        this.fileStorage = fileStorage;
    }

    public TestReportNode(FileTempStorage fileStorage, String name, Status status) {
        this.fileStorage = fileStorage;
        this.name = name;
        this.status = status;
    }

    public Date getTime() {
        return this.time;
    }

    public void setTime(Date time) {
        this.time = time;
    }

    public TestReportNode withAttachment(String name, File file) {
        if (this.attachments == null) {
            this.attachments = new LinkedList<String>();
        }
        String attachmentName = this.getFileStorage().registerFile(name, file);
        this.attachments.add(attachmentName);
        return this;
    }

    public TestReportNode withTextAttachment(String name, String text) {
        try {
            File textFile = File.createTempFile(name, ".txt");
            FileUtils.write((File)textFile, (CharSequence)text);
            this.withAttachment(name, textFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this;
    }

    private FileTempStorage getFileStorage() {
        return this.fileStorage;
    }

    private synchronized Map<String, ReportExtra> ensureExtras() {
        if (this.extras == null) {
            this.extras = new HashMap<String, ReportExtra>();
        }
        return this.extras;
    }

    public TestReportNode withExtrasText(String name, String text) {
        this.ensureExtras().put(name, new ReportExtraText(text));
        return this;
    }

    public TestReportNode withExtrasLink(String name, String link) {
        this.ensureExtras().put(name, new ReportExtraLink(link));
        return this;
    }

    public TestReportNode withExtrasImage(String name, File image) {
        this.ensureExtras().put(name, new ReportExtraImage(this.getFileStorage().registerFile(image.getName(), image)));
        return this;
    }

    public TestReportNode withExtrasFile(String name, File file) {
        this.ensureExtras().put(name, new ReportExtraFile(this.getFileStorage().registerFile(file.getName(), file)));
        return this;
    }

    public Map<String, ReportExtra> getExtras() {
        return this.extras;
    }

    public void setExtras(Map<String, ReportExtra> extras) {
        this.extras = extras;
    }

    public TestReportNode withDetails(String details) {
        this.addNode(new TextReportNode(this.fileStorage, details));
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public synchronized void addNode(TestReportNode node) {
        if (this.nodes == null) {
            this.nodes = new LinkedList<TestReportNode>();
        }
        this.nodes.add(node);
        node.setParent(this);
    }

    private void setParent(TestReportNode node) {
        this.parent = node;
    }

    public TestReportNode getParent() {
        return this.parent;
    }

    public List<TestReportNode> getNodes() {
        return this.nodes;
    }

    public void setNodes(List<TestReportNode> nodes) {
        this.nodes = nodes;
    }

    public TestStatistic fetchStatistic(TestStatistic testStatistic) {
        if (this.nodes != null && this.nodes.size() > 0) {
            for (TestReportNode node : this.nodes) {
                node.fetchStatistic(testStatistic);
            }
        } else {
            testStatistic.setTotal(testStatistic.getTotal() + 1);
            if (this.status == Status.INFO) {
                testStatistic.setPassed(testStatistic.getPassed() + 1);
            } else if (this.status == Status.ERROR) {
                testStatistic.setErrors(testStatistic.getErrors() + 1);
            } else {
                testStatistic.setWarnings(testStatistic.getWarnings() + 1);
            }
        }
        return testStatistic;
    }

    public String getType() {
        return "node";
    }

    public List<String> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(List<String> attachments) {
        this.attachments = attachments;
    }

    public static enum Status {
        INFO("info"),
        WARN("warn"),
        ERROR("error");

        private final String name;

        private Status(String name) {
            this.name = name;
        }

        @JsonValue
        public String toString() {
            return this.name;
        }
    }
}

