/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.runner;

import com.galenframework.reports.GalenTestInfo;
import com.galenframework.runner.CompleteListener;
import com.galenframework.specs.Spec;
import com.galenframework.specs.page.PageSection;
import com.galenframework.suite.GalenPageAction;
import com.galenframework.tests.GalenTest;
import com.galenframework.validation.PageValidation;
import com.galenframework.validation.ValidationResult;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CombinedListener
implements CompleteListener {
    private static final Logger LOG = LoggerFactory.getLogger(CombinedListener.class);
    List<CompleteListener> listeners = new LinkedList<CompleteListener>();

    public void add(CompleteListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void onTestFinished(GalenTest test) {
        for (CompleteListener listener : this.listeners) {
            try {
                listener.onTestFinished(test);
            }
            catch (Exception ex) {
                LOG.error("Unknown error during finishing test", (Throwable)ex);
            }
        }
    }

    @Override
    public void onTestStarted(GalenTest test) {
        for (CompleteListener listener : this.listeners) {
            try {
                listener.onTestStarted(test);
            }
            catch (Exception ex) {
                LOG.error("Unknown error starting finishing test", (Throwable)ex);
            }
        }
    }

    @Override
    public void onObject(PageValidation pageValidation, String objectName) {
        for (CompleteListener listener : this.listeners) {
            try {
                listener.onObject(pageValidation, objectName);
            }
            catch (Exception ex) {
                LOG.trace("Unknown error during test execution", (Throwable)ex);
            }
        }
    }

    @Override
    public void onAfterObject(PageValidation pageValidation, String objectName) {
        for (CompleteListener listener : this.listeners) {
            try {
                listener.onAfterObject(pageValidation, objectName);
            }
            catch (Exception ex) {
                LOG.trace("Unknown error during test execution", (Throwable)ex);
            }
        }
    }

    @Override
    public void onBeforeSpec(PageValidation pageValidation, String objectName, Spec spec) {
        for (CompleteListener listener : this.listeners) {
            try {
                listener.onBeforeSpec(pageValidation, objectName, spec);
            }
            catch (Exception ex) {
                LOG.trace("Unknown error during test execution", (Throwable)ex);
            }
        }
    }

    @Override
    public void onSpecError(PageValidation pageValidation, String objectName, Spec spec, ValidationResult result) {
        for (CompleteListener listener : this.listeners) {
            try {
                listener.onSpecError(pageValidation, objectName, spec, result);
            }
            catch (Exception ex) {
                LOG.trace("Unknown error when checking spec errors", (Throwable)ex);
            }
        }
    }

    @Override
    public void onSpecSuccess(PageValidation pageValidation, String objectName, Spec spec, ValidationResult result) {
        for (CompleteListener listener : this.listeners) {
            try {
                listener.onSpecSuccess(pageValidation, objectName, spec, result);
            }
            catch (Exception ex) {
                LOG.trace("Unknown error when checking spec success", (Throwable)ex);
            }
        }
    }

    @Override
    public void done() {
        for (CompleteListener listener : this.listeners) {
            try {
                listener.done();
            }
            catch (Exception ex) {
                LOG.trace("Unknown error during completion", (Throwable)ex);
            }
        }
    }

    @Override
    public void onGlobalError(Exception e) {
        for (CompleteListener listener : this.listeners) {
            try {
                listener.onGlobalError(e);
            }
            catch (Exception ex) {
                LOG.trace("Unknown error when checking global errors", (Throwable)ex);
            }
        }
    }

    @Override
    public void onBeforePageAction(GalenPageAction action) {
        for (CompleteListener listener : this.listeners) {
            try {
                listener.onBeforePageAction(action);
            }
            catch (Exception ex) {
                LOG.trace("Unknown error during before page action", (Throwable)ex);
            }
        }
    }

    @Override
    public void onAfterPageAction(GalenPageAction action) {
        for (CompleteListener listener : this.listeners) {
            try {
                listener.onAfterPageAction(action);
            }
            catch (Exception ex) {
                LOG.trace("Unknown error during after page action", (Throwable)ex);
            }
        }
    }

    @Override
    public void onBeforeSection(PageValidation pageValidation, PageSection pageSection) {
        for (CompleteListener listener : this.listeners) {
            try {
                listener.onBeforeSection(pageValidation, pageSection);
            }
            catch (Exception ex) {
                LOG.trace("Unknown error during before section", (Throwable)ex);
            }
        }
    }

    @Override
    public void onAfterSection(PageValidation pageValidation, PageSection pageSection) {
        for (CompleteListener listener : this.listeners) {
            try {
                listener.onAfterSection(pageValidation, pageSection);
            }
            catch (Exception ex) {
                LOG.trace("Unknown error during after section", (Throwable)ex);
            }
        }
    }

    @Override
    public void onSubLayout(PageValidation pageValidation, String objectName) {
        for (CompleteListener listener : this.listeners) {
            try {
                listener.onSubLayout(pageValidation, objectName);
            }
            catch (Exception ex) {
                LOG.trace("Unknown error during after section", (Throwable)ex);
            }
        }
    }

    @Override
    public void onAfterSubLayout(PageValidation pageValidation, String objectName) {
        for (CompleteListener listener : this.listeners) {
            try {
                listener.onAfterSubLayout(pageValidation, objectName);
            }
            catch (Exception ex) {
                LOG.trace("Unknown error during after section", (Throwable)ex);
            }
        }
    }

    @Override
    public void onSpecGroup(PageValidation pageValidation, String specGroupName) {
        for (CompleteListener listener : this.listeners) {
            try {
                listener.onSpecGroup(pageValidation, specGroupName);
            }
            catch (Exception ex) {
                LOG.trace("Unknown error during spec group event", (Throwable)ex);
            }
        }
    }

    @Override
    public void onAfterSpecGroup(PageValidation pageValidation, String specGroupName) {
        for (CompleteListener listener : this.listeners) {
            try {
                listener.onAfterSpecGroup(pageValidation, specGroupName);
            }
            catch (Exception ex) {
                LOG.trace("Unknown error during after spec group event", (Throwable)ex);
            }
        }
    }

    @Override
    public void beforeTestSuite(List<GalenTest> tests) {
        for (CompleteListener listener : this.listeners) {
            try {
                listener.beforeTestSuite(tests);
            }
            catch (Exception ex) {
                LOG.trace("Unknown error during before testsuite", (Throwable)ex);
            }
        }
    }

    @Override
    public void afterTestSuite(List<GalenTestInfo> tests) {
        for (CompleteListener listener : this.listeners) {
            try {
                listener.afterTestSuite(tests);
            }
            catch (Exception ex) {
                LOG.trace("Unknown error during after testsuite", (Throwable)ex);
            }
        }
    }
}

