/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.runner;

import com.galenframework.browser.Browser;
import com.galenframework.reports.TestReport;
import com.galenframework.runner.GalenPageRunner;
import com.galenframework.runner.TestListener;
import com.galenframework.suite.GalenPageTest;
import com.galenframework.tests.GalenBasicTest;
import com.galenframework.validation.ValidationListener;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GalenBasicTestRunner {
    private static final Logger LOG = LoggerFactory.getLogger(GalenBasicTestRunner.class);
    private TestListener testListener;
    private ValidationListener validationListener;

    public GalenBasicTestRunner withSuiteListener(TestListener suiteListener) {
        this.setSuiteListener(suiteListener);
        return this;
    }

    public TestListener getSuiteListener() {
        return this.testListener;
    }

    public void setSuiteListener(TestListener suiteListener) {
        this.testListener = suiteListener;
    }

    public TestReport runTest(TestReport report, GalenBasicTest test) throws Exception {
        if (test == null) {
            throw new IllegalArgumentException("Test can not be null");
        }
        List<GalenPageTest> pageTests = test.getPageTests();
        GalenPageRunner pageRunner = new GalenPageRunner(report);
        pageRunner.setValidationListener(this.validationListener);
        for (GalenPageTest pageTest : pageTests) {
            report.gotoRoot();
            report.sectionStart(pageTest.getTitle());
            Browser browser = pageTest.getBrowserFactory().openBrowser();
            try {
                pageRunner.run(browser, pageTest);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                report.error(ex);
            }
            try {
                browser.quit();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            report.sectionEnd();
        }
        return report;
    }

    public ValidationListener getValidationListener() {
        return this.validationListener;
    }

    public void setValidationListener(ValidationListener validationListener) {
        this.validationListener = validationListener;
    }
}

